/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.bpmn2.FlowElement;
import org.jbpm.simulation.PathContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathContextManager {
    private Stack<PathContext> paths = new Stack();
    private List<PathContext> completePaths = new ArrayList<PathContext>();

    public PathContext getContextFromStack() {
        if (this.paths.isEmpty()) {
            this.paths.push(new PathContext());
        }
        return this.paths.peek();
    }

    public void addToPath(FlowElement element, PathContext context) {
        if (context.getType() == PathContext.Type.ROOT) {
            context.addPathElement(element);
        } else {
            for (PathContext ctx : this.paths) {
                if (ctx.getType() == PathContext.Type.ROOT) continue;
                ctx.addPathElement(element);
            }
        }
    }

    public PathContext cloneGiven(PathContext toclone) {
        PathContext clone = new PathContext(PathContext.Type.ACTIVE);
        clone.setCanBeFinished(toclone.isCanBeFinished());
        clone.setPathElements(new ArrayList<FlowElement>(toclone.getPathElements()));
        this.paths.push(clone);
        return clone;
    }

    public Stack<PathContext> getPaths() {
        return this.paths;
    }

    public void finalizePath() {
        PathContext context = this.getContextFromStack();
        if (context.isCanBeFinished()) {
            PathContext completePath = this.paths.pop();
            this.completePaths.add(completePath);
        }
    }

    public void complete() {
        for (PathContext context : this.paths) {
            if (context.getType() == PathContext.Type.ROOT) continue;
            this.completePaths.add(context);
        }
    }

    public List<PathContext> getCompletePaths() {
        return this.completePaths;
    }
}

