/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.SequenceFlow;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathContextManager;
import org.jbpm.simulation.handler.MainElementHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayElementHandler
extends MainElementHandler {
    private PathContextManager manager;

    @Override
    public void handle(FlowElement element, PathContextManager manager) {
        this.manager = manager;
        if (element instanceof ExclusiveGateway) {
            this.handleExclusiveGateway(this.getOutgoing(element));
        } else if (element instanceof InclusiveGateway) {
            this.handleInclusiveGateway(this.getOutgoing(element));
        } else if (element instanceof ParallelGateway) {
            this.handleParallelGateway(this.getOutgoing(element));
        } else {
            throw new UnsupportedOperationException("Not supported element to handle " + element.eClass().getName());
        }
    }

    protected void handleExclusiveGateway(List<SequenceFlow> outgoing) {
        ArrayList<PathContext> locked = new ArrayList<PathContext>();
        PathContext context = this.manager.getContextFromStack();
        for (SequenceFlow seqFlow : outgoing) {
            FlowNode target = seqFlow.getTargetRef();
            PathContext separatePath = this.manager.cloneGiven(context);
            this.manager.addToPath((FlowElement)seqFlow, separatePath);
            super.handle((FlowElement)target, this.manager);
            separatePath.setLocked(true);
            locked.add(separatePath);
        }
        for (PathContext ctx : locked) {
            ctx.setLocked(false);
        }
    }

    protected void handleInclusiveGateway(List<SequenceFlow> outgoing) {
        this.handleExclusiveGateway(outgoing);
        if (outgoing.size() > 2) {
            ArrayList<SequenceFlow> copy = new ArrayList<SequenceFlow>(outgoing);
            ArrayList<SequenceFlow> andCombination = null;
            for (SequenceFlow flow : outgoing) {
                copy.remove(flow);
                for (SequenceFlow copyFlow : copy) {
                    this.manager.cloneGiven(this.manager.getContextFromStack());
                    andCombination = new ArrayList<SequenceFlow>();
                    andCombination.add(flow);
                    andCombination.add(copyFlow);
                    this.handleParallelGateway(andCombination);
                }
            }
        }
        this.handleParallelGateway(outgoing);
    }

    protected void handleParallelGateway(List<SequenceFlow> outgoing) {
        PathContext context = this.manager.getContextFromStack();
        context.setCanBeFinished(false);
        int counter = 0;
        for (SequenceFlow seqFlow : outgoing) {
            FlowNode target = seqFlow.getTargetRef();
            if (++counter == outgoing.size()) {
                context.setCanBeFinished(true);
            }
            this.manager.addToPath((FlowElement)seqFlow, context);
            super.handle((FlowElement)target, this.manager);
        }
    }
}

