/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.LinkEventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathContextManager;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.handler.ElementHandler;
import org.jbpm.simulation.handler.HandlerRegistry;
import org.jbpm.simulation.util.JBPMBpmn2ResourceFactoryImpl;
import org.jbpm.simulation.util.JBPMBpmn2ResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMN2PathFinderImpl
implements PathFinder {
    private PathContextManager manager;
    private Definitions definitions;
    private List<FlowElement> triggerElements = new ArrayList<FlowElement>();
    private Map<String, FlowElement> catchingEvents = new HashMap<String, FlowElement>();

    public BPMN2PathFinderImpl(String bpmn2xml) {
        this.manager = new PathContextManager();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(bpmn2xml.getBytes("UTF-8"));
            this.definitions = this.getDefinitions(is);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public BPMN2PathFinderImpl(File bpmn2File) {
        this.manager = new PathContextManager();
        try {
            FileInputStream is = new FileInputStream(bpmn2File);
            this.definitions = this.getDefinitions(is);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public BPMN2PathFinderImpl(InputStream bpmn2Stream) {
        this.manager = new PathContextManager();
        this.definitions = this.getDefinitions(bpmn2Stream);
    }

    public BPMN2PathFinderImpl(Definitions bpmn2Defs) {
        this.manager = new PathContextManager();
        this.definitions = bpmn2Defs;
    }

    @Override
    public List<PathContext> findPaths() {
        List rootElements = this.definitions.getRootElements();
        for (RootElement root : rootElements) {
            if (!(root instanceof Process)) continue;
            Process process = (Process)root;
            List flowElements = process.getFlowElements();
            for (FlowElement fElement : flowElements) {
                if (fElement instanceof StartEvent) {
                    this.triggerElements.add(0, fElement);
                    continue;
                }
                if (fElement instanceof Activity && BPMN2PathFinderImpl.isAdHocProcess(process)) {
                    Activity act = (Activity)fElement;
                    if (act.getIncoming() != null && act.getIncoming().size() != 0) continue;
                    this.triggerElements.add(0, fElement);
                    continue;
                }
                if (!(fElement instanceof IntermediateCatchEvent)) continue;
                String key = null;
                List eventDefinitions = ((IntermediateCatchEvent)fElement).getEventDefinitions();
                if (eventDefinitions == null) continue;
                for (EventDefinition edef : eventDefinitions) {
                    if (edef instanceof SignalEventDefinition) {
                        key = ((SignalEventDefinition)edef).getSignalRef();
                    } else if (edef instanceof MessageEventDefinition) {
                        key = ((MessageEventDefinition)edef).getMessageRef().getId();
                    } else if (edef instanceof LinkEventDefinition) {
                        key = ((LinkEventDefinition)edef).getName();
                    } else if (edef instanceof CompensateEventDefinition) {
                        key = ((CompensateEventDefinition)edef).getActivityRef().getId();
                    }
                    if (key == null) continue;
                    this.catchingEvents.put(key, fElement);
                }
            }
        }
        ElementHandler handler = HandlerRegistry.getMainHandler();
        for (FlowElement fe : this.triggerElements) {
            if (!(fe instanceof StartEvent) && !(fe instanceof Activity)) continue;
            handler.handle(fe, this.manager);
        }
        this.manager.complete();
        return this.manager.getCompletePaths();
    }

    protected Definitions getDefinitions(InputStream is) {
        try {
            EList errors;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new JBPMBpmn2ResourceFactoryImpl());
            resourceSet.getPackageRegistry().put((Object)"http://www.omg.org/spec/BPMN/20100524/MODEL", (Object)Bpmn2Package.eINSTANCE);
            JBPMBpmn2ResourceImpl resource = (JBPMBpmn2ResourceImpl)resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
            resource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
            resource.setEncoding("UTF-8");
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            resource.load(is, options);
            EList warnings = resource.getWarnings();
            if (warnings != null && !warnings.isEmpty()) {
                for (Resource.Diagnostic diagnostic : warnings) {
                    System.out.println("Warning: " + diagnostic.getMessage());
                }
            }
            if ((errors = resource.getErrors()) != null && !errors.isEmpty()) {
                for (Resource.Diagnostic diagnostic : errors) {
                    System.out.println("Error: " + diagnostic.getMessage());
                }
                throw new IllegalStateException("Error parsing process definition");
            }
            return ((DocumentRoot)resource.getContents().get(0)).getDefinitions();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    protected static String streamToString(InputStream is) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            is.close();
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    protected static boolean isAdHocProcess(Process process) {
        for (FeatureMap.Entry entry : process.getAnyAttribute()) {
            if (!entry.getEStructuralFeature().getName().equals("adHoc")) continue;
            return Boolean.parseBoolean(((String)entry.getValue()).trim());
        }
        return false;
    }

    @Override
    public <E> E findPaths(PathFormatConverter<E> converter) {
        this.findPaths();
        return converter.convert(this.manager.getCompletePaths());
    }
}

