/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.SequenceFlow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathContext {
    private Set<FlowElement> pathElements = new HashSet<FlowElement>();
    private Type type;
    private boolean canBeFinished = true;
    private boolean locked = false;
    private String id = String.valueOf(UUID.randomUUID());
    private int canBeFinishedCounter = 0;

    protected int getCanBeFinishedCounter() {
        return this.canBeFinishedCounter;
    }

    protected void setCanBeFinishedCounter(int canBeFinishedCounter) {
        this.canBeFinishedCounter = canBeFinishedCounter;
    }

    public PathContext() {
        this.setType(Type.ROOT);
    }

    public PathContext(Type type) {
        this.setType(type);
    }

    public void addPathElement(FlowElement element) {
        if (!this.locked) {
            this.pathElements.add(element);
        }
    }

    public void addAllPathElement(List<SequenceFlow> elements) {
        if (!this.locked) {
            this.pathElements.addAll(elements);
        }
    }

    public Set<FlowElement> getPathElements() {
        return this.pathElements;
    }

    public void setPathElements(Set<FlowElement> pathElements) {
        this.pathElements = pathElements;
    }

    public boolean isCanBeFinished() {
        return this.canBeFinished;
    }

    public void setCanBeFinishedNoIncrement(boolean canBeFinished) {
        this.canBeFinished = canBeFinished;
    }

    public void setCanBeFinished(boolean canBeFinished) {
        if (canBeFinished) {
            if (this.canBeFinishedCounter == 1) {
                this.canBeFinished = true;
            }
            --this.canBeFinishedCounter;
        } else {
            if (this.canBeFinishedCounter == 0) {
                this.canBeFinished = false;
            }
            ++this.canBeFinishedCounter;
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public String getId() {
        return this.id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ROOT,
        ACTIVE,
        COMPLETED,
        TEMP;

    }
}

