/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.jbpm.simulation.PathContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathContextManager {
    private Stack<PathContext> paths = new Stack();
    private List<PathContext> completePaths = new ArrayList<PathContext>();
    protected Map<String, FlowElement> catchingEvents = null;

    public Map<String, FlowElement> getCatchingEvents() {
        return this.catchingEvents;
    }

    public void setCatchingEvents(Map<String, FlowElement> catchingEvents) {
        this.catchingEvents = catchingEvents;
    }

    public PathContext getContextFromStack() {
        if (this.paths.isEmpty()) {
            this.paths.push(new PathContext());
        }
        return this.paths.peek();
    }

    public void addToPath(FlowElement element, PathContext context) {
        if (context.getType() == PathContext.Type.ROOT) {
            context.addPathElement(element);
        } else {
            for (PathContext ctx : this.paths) {
                if (ctx.getType() != PathContext.Type.ACTIVE) continue;
                ctx.addPathElement(element);
            }
        }
    }

    public void addAllToPath(List<SequenceFlow> elements, PathContext context) {
        if (context.getType() == PathContext.Type.ROOT) {
            context.addAllPathElement(elements);
        } else {
            for (PathContext ctx : this.paths) {
                if (ctx.getType() != PathContext.Type.ACTIVE) continue;
                ctx.addAllPathElement(elements);
            }
        }
    }

    public PathContext cloneGiven(PathContext toclone) {
        PathContext clone = new PathContext(PathContext.Type.ACTIVE);
        clone.setCanBeFinishedNoIncrement(toclone.isCanBeFinished());
        clone.setCanBeFinishedCounter(toclone.getCanBeFinishedCounter());
        clone.setPathElements(new HashSet<FlowElement>(toclone.getPathElements()));
        this.paths.push(clone);
        return clone;
    }

    public PathContext cloneGivenWithoutPush(PathContext toclone) {
        PathContext clone = new PathContext(PathContext.Type.ACTIVE);
        clone.setCanBeFinishedNoIncrement(toclone.isCanBeFinished());
        clone.setCanBeFinishedCounter(toclone.getCanBeFinishedCounter());
        clone.setPathElements(new HashSet<FlowElement>(toclone.getPathElements()));
        toclone.setType(PathContext.Type.TEMP);
        return clone;
    }

    public Stack<PathContext> getPaths() {
        return this.paths;
    }

    public void finalizePath() {
        PathContext context = this.getContextFromStack();
        if (context.isCanBeFinished()) {
            PathContext completePath = this.paths.pop();
            completePath.setType(PathContext.Type.COMPLETED);
            this.completePaths.add(completePath);
        }
    }

    public void finalizePath(PathContext context) {
        if (context.isCanBeFinished()) {
            context.setType(PathContext.Type.COMPLETED);
            this.completePaths.add(context);
        }
    }

    public void clearCurrentContext() {
        this.paths.pop();
    }

    public void complete() {
        for (PathContext context : this.paths) {
            if (context.getType() == PathContext.Type.ROOT || context.getType() == PathContext.Type.TEMP) continue;
            this.completePaths.add(context);
        }
    }

    public List<PathContext> getCompletePaths() {
        return this.completePaths;
    }
}

