/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.ResourceType;
import org.drools.command.Command;
import org.drools.fluent.knowledge.KnowledgeBaseSimFluent;
import org.drools.fluent.knowledge.KnowledgeBuilderSimFluent;
import org.drools.fluent.simulation.impl.DefaultSimulationFluent;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.jbpm.simulation.PathFinder;
import org.jbpm.simulation.PathFinderFactory;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationContextFactory;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.SimulationRepository;
import org.jbpm.simulation.converter.SimulationFilterPathFormatConverter;
import org.jbpm.simulation.impl.BPMN2SimulationDataProvider;
import org.jbpm.simulation.impl.SimulateProcessPathCommand;
import org.jbpm.simulation.impl.SimulationPath;
import org.jbpm.simulation.impl.WorkingMemorySimulationRepository;

public class SimulationRunner {
    public static SimulationRepository runSimulation(String processId, String bpmn2Container, int numberOfAllInstances, long interval, String ... rules) {
        return SimulationRunner.runSimulation(processId, bpmn2Container, numberOfAllInstances, interval, false, rules);
    }

    public static SimulationRepository runSimulation(String processId, String bpmn2Container, int numberOfAllInstances, long interval, boolean runRules, String ... rules) {
        Resource[] resources = new Resource[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            resources[i] = ResourceFactory.newClassPathResource((String)rules[i]);
        }
        return SimulationRunner.runSimulation(processId, bpmn2Container, numberOfAllInstances, interval, runRules, resources);
    }

    public static SimulationRepository runSimulation(String processId, String bpmn2Container, int numberOfAllInstances, long interval, boolean runRules, Resource ... rules) {
        SimulationContext context = SimulationContextFactory.newContext(new BPMN2SimulationDataProvider(bpmn2Container), new WorkingMemorySimulationRepository(runRules, rules));
        SimulationDataProvider provider = context.getDataProvider();
        PathFinder finder = PathFinderFactory.getInstance(bpmn2Container);
        List<SimulationPath> paths = finder.findPaths(new SimulationFilterPathFormatConverter(provider));
        DefaultSimulationFluent f = new DefaultSimulationFluent();
        int counter = 0;
        int remainingInstances = numberOfAllInstances;
        for (SimulationPath path : paths) {
            double probability = provider.calculatePathProbability(path);
            ((KnowledgeBaseSimFluent)((KnowledgeBuilderSimFluent)f.newPath("path" + counter).newKnowledgeBuilder().add(ResourceFactory.newReaderResource((Reader)new StringReader(bpmn2Container)), ResourceType.BPMN2)).end("ROOT", KnowledgeBuilder.class.getName()).newKnowledgeBase().addKnowledgePackages()).end("ROOT", KnowledgeBase.class.getName());
            int instancesOfPath = 1;
            if (numberOfAllInstances > 1) {
                instancesOfPath = (int)Math.round((double)numberOfAllInstances * probability);
                if (instancesOfPath > remainingInstances) {
                    instancesOfPath = remainingInstances;
                }
                remainingInstances -= instancesOfPath;
                for (int i = 0; i < instancesOfPath; ++i) {
                    f.newStep(interval * (long)i).newStatefulKnowledgeSession().end("ROOT", StatefulKnowledgeSession.class.getName()).addCommand((Command)new SimulateProcessPathCommand(processId, context, path));
                }
            } else {
                f.newStep(interval).newStatefulKnowledgeSession().end("ROOT", StatefulKnowledgeSession.class.getName()).addCommand((Command)new SimulateProcessPathCommand(processId, context, path));
                break;
            }
            ++counter;
        }
        f.runSimulation();
        return context.getRepository();
    }
}

