/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathFormatConverter;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.impl.SimulationPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationFilterPathFormatConverter
implements PathFormatConverter<List<SimulationPath>> {
    private SimulationDataProvider provider;

    public SimulationFilterPathFormatConverter() {
    }

    public SimulationFilterPathFormatConverter(SimulationDataProvider provider) {
        this.provider = provider;
    }

    @Override
    public List<SimulationPath> convert(List<PathContext> paths) {
        ArrayList<SimulationPath> allPaths = new ArrayList<SimulationPath>();
        for (PathContext context : paths) {
            SimulationPath simPath = new SimulationPath();
            for (FlowElement fe : context.getPathElements()) {
                if (fe instanceof SequenceFlow) {
                    simPath.addSequenceFlow(fe.getId());
                    continue;
                }
                simPath.addActivity(fe.getId());
            }
            allPaths.add(simPath);
            if (this.provider == null) continue;
            this.provider.calculatePathProbability(simPath);
        }
        Collections.sort(allPaths, new Comparator<SimulationPath>(){

            @Override
            public int compare(SimulationPath o1, SimulationPath o2) {
                double difference = o1.getProbability() - o2.getProbability();
                if (difference > 0.0) {
                    return -1;
                }
                if (difference < 0.0) {
                    return 1;
                }
                return 0;
            }
        });
        return allPaths;
    }
}

