/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.SequenceFlow;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathContextManager;
import org.jbpm.simulation.handler.HandlerRegistry;
import org.jbpm.simulation.handler.MainElementHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityElementHandler
extends MainElementHandler {
    @Override
    public boolean handle(FlowElement element, PathContextManager manager) {
        List<SequenceFlow> outgoing = this.getOutgoing(element);
        if (outgoing.size() == 0) {
            return false;
        }
        PathContext context = manager.getContextFromStack();
        List bEvents = ((Activity)element).getBoundaryEventRefs();
        if (bEvents != null && bEvents.size() > 0) {
            boolean cancelActivity = false;
            for (BoundaryEvent bEvent : bEvents) {
                manager.addToPath((FlowElement)bEvent, context);
                outgoing.addAll(bEvent.getOutgoing());
                cancelActivity = bEvent.isCancelActivity();
                this.handleSeparatePaths(outgoing, manager);
                this.handleCombinedPaths(outgoing, manager);
                if (cancelActivity) continue;
                this.handleAllPaths(outgoing, manager);
            }
            return true;
        }
        HandlerRegistry.getHandler().handle(element, manager);
        return false;
    }

    protected void handleSeparatePaths(List<SequenceFlow> outgoing, PathContextManager manager) {
        ArrayList<PathContext> locked = new ArrayList<PathContext>();
        PathContext context = manager.getContextFromStack();
        for (SequenceFlow seqFlow : outgoing) {
            FlowNode target = seqFlow.getTargetRef();
            PathContext separatePath = manager.cloneGiven(context);
            manager.addToPath((FlowElement)seqFlow, separatePath);
            super.handle((FlowElement)target, manager);
            separatePath.setLocked(true);
            locked.add(separatePath);
        }
        for (PathContext ctx : locked) {
            ctx.setLocked(false);
        }
    }

    protected void handleAllPaths(List<SequenceFlow> outgoing, PathContextManager manager) {
        PathContext context = manager.getContextFromStack();
        context.setCanBeFinished(false);
        int counter = 0;
        for (SequenceFlow seqFlow : outgoing) {
            FlowNode target = seqFlow.getTargetRef();
            if (++counter == outgoing.size()) {
                context.setCanBeFinished(true);
            }
            manager.addToPath((FlowElement)seqFlow, context);
            super.handle((FlowElement)target, manager);
        }
    }

    protected void handleCombinedPaths(List<SequenceFlow> outgoing, PathContextManager manager) {
        if (outgoing.size() > 2) {
            ArrayList<SequenceFlow> copy = new ArrayList<SequenceFlow>(outgoing);
            ArrayList<SequenceFlow> andCombination = null;
            for (SequenceFlow flow : outgoing) {
                copy.remove(flow);
                for (SequenceFlow copyFlow : copy) {
                    manager.cloneGiven(manager.getContextFromStack());
                    andCombination = new ArrayList<SequenceFlow>();
                    andCombination.add(flow);
                    andCombination.add(copyFlow);
                    this.handleAllPaths(andCombination, manager);
                }
            }
        }
    }
}

