/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.handler;

import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.SequenceFlow;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathContextManager;
import org.jbpm.simulation.handler.DefaultElementHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvergingGatewayElementHandler
extends DefaultElementHandler {
    private PathContextManager manager;

    @Override
    public boolean handle(FlowElement element, PathContextManager manager) {
        this.manager = manager;
        if (element instanceof ExclusiveGateway) {
            return false;
        }
        if (element instanceof InclusiveGateway) {
            return true;
        }
        if (element instanceof ParallelGateway) {
            this.handleParallelGateway(element, this.getOutgoing(element));
            return true;
        }
        throw new UnsupportedOperationException("Not supported element to handle " + element.eClass().getName());
    }

    protected void handleParallelGateway(FlowElement element, List<SequenceFlow> outgoing) {
        PathContext context = this.manager.getContextFromStack();
        boolean canBeFinished = context.isCanBeFinished();
        if (canBeFinished && context.getType() != PathContext.Type.ROOT) {
            for (SequenceFlow seqFlow : outgoing) {
                this.manager.addToPath((FlowElement)seqFlow, context);
                this.manager.addToPath((FlowElement)seqFlow.getTargetRef(), context);
            }
            Iterator it = this.manager.getPaths().iterator();
            while (it.hasNext()) {
                PathContext pathContext = (PathContext)it.next();
                if (pathContext.getType() != PathContext.Type.ACTIVE) continue;
                pathContext.setCanBeFinishedNoIncrement(canBeFinished);
                this.manager.finalizePath(pathContext);
                it.remove();
            }
        } else {
            super.handle(element, this.manager);
        }
    }
}

