/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.handler;

import java.util.List;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathContextManager;
import org.jbpm.simulation.handler.MainElementHandler;

public class EmbeddedSubprocessHandler
extends MainElementHandler {
    public boolean handle(FlowElement element, PathContextManager manager) {
        SubProcess subProcess = (SubProcess)element;
        List sbElements = subProcess.getFlowElements();
        StartEvent start = null;
        for (FlowElement sbElement : sbElements) {
            if (!(sbElement instanceof StartEvent)) continue;
            start = (StartEvent)sbElement;
            break;
        }
        boolean canBeFinsihed = manager.getContextFromStack().isCanBeFinished();
        manager.getContextFromStack().setCanBeFinishedNoIncrement(false);
        super.handle((FlowElement)start, manager);
        manager.getContextFromStack().setCanBeFinishedNoIncrement(canBeFinsihed);
        List<SequenceFlow> out = this.getOutgoing(element);
        for (SequenceFlow flow : out) {
            manager.addToPath((FlowElement)flow, manager.getContextFromStack());
            super.handle((FlowElement)flow.getTargetRef(), manager);
        }
        if (canBeFinsihed) {
            PathContext context;
            boolean goOn = true;
            while (goOn && (context = manager.getContextFromStack()).getType() == PathContext.Type.ACTIVE) {
                context.setCanBeFinishedNoIncrement(canBeFinsihed);
                manager.finalizePath();
            }
        }
        return true;
    }
}

