/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.handler;

import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.jbpm.simulation.PathContext;
import org.jbpm.simulation.PathContextManager;
import org.jbpm.simulation.handler.ElementHandler;
import org.jbpm.simulation.handler.HandlerRegistry;
import org.jbpm.simulation.util.BPMN2Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainElementHandler
implements ElementHandler {
    @Override
    public boolean handle(FlowElement element, PathContextManager manager) {
        List<SequenceFlow> outgoing;
        PathContext context = manager.getContextFromStack();
        if (!(element instanceof SubProcess)) {
            manager.addToPath(element, context);
        }
        if ((outgoing = this.getOutgoing(element)) != null && !outgoing.isEmpty()) {
            Gateway gateway;
            boolean handled = false;
            handled = element instanceof Gateway ? ((gateway = (Gateway)element).getGatewayDirection() == GatewayDirection.DIVERGING ? HandlerRegistry.getHandler(element).handle(element, manager) : (gateway instanceof ParallelGateway ? HandlerRegistry.getHandler(element).handle(element, manager) : HandlerRegistry.getHandler().handle(element, manager))) : (element instanceof Activity ? HandlerRegistry.getHandler(element).handle(element, manager) : HandlerRegistry.getHandler().handle(element, manager));
            if (!handled && BPMN2Utils.isAdHoc(element)) {
                manager.clearCurrentContext();
            }
        } else {
            ElementHandler handelr = HandlerRegistry.getHandler(element);
            if (handelr != null) {
                boolean handled = handelr.handle(element, manager);
                if (!handled) {
                    manager.finalizePath();
                }
            } else {
                manager.finalizePath();
            }
        }
        return true;
    }

    protected List<EventDefinition> getEventDefinitions(FlowElement startAt) {
        List throwDefinitions = null;
        if (startAt instanceof IntermediateThrowEvent) {
            throwDefinitions = ((IntermediateThrowEvent)startAt).getEventDefinitions();
        } else if (startAt instanceof EndEvent) {
            EndEvent end = (EndEvent)startAt;
            throwDefinitions = end.getEventDefinitions();
        }
        return throwDefinitions;
    }

    protected List<SequenceFlow> getOutgoing(FlowElement element) {
        List outgoing = null;
        if (element instanceof StartEvent) {
            outgoing = ((StartEvent)element).getOutgoing();
        } else if (element instanceof SubProcess) {
            SubProcess subProcess = (SubProcess)element;
            outgoing = subProcess.getOutgoing();
        } else if (element instanceof Event) {
            outgoing = ((Event)element).getOutgoing();
        } else if (element instanceof Activity) {
            outgoing = ((Activity)element).getOutgoing();
        } else if (element instanceof EndEvent) {
            outgoing = ((EndEvent)element).getOutgoing();
        } else if (element instanceof Gateway) {
            Gateway gateway = (Gateway)element;
            outgoing = gateway.getOutgoing();
        }
        return outgoing;
    }
}

