/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.ht;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;
import org.drools.definition.process.Node;
import org.jbpm.simulation.SimulationContext;
import org.jbpm.simulation.SimulationDataProvider;
import org.jbpm.simulation.TimeGenerator;
import org.jbpm.simulation.TimeGeneratorFactory;
import org.jbpm.simulation.impl.ht.StaffPool;
import org.jbpm.simulation.util.SimulationUtils;

public class StaffPoolImpl
implements StaffPool {
    private Map<String, Object> properties;
    private int poolSize;
    private long duration;
    private List<Long> allocatedTill = new ArrayList<Long>();
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private long workingHours = 28800000L;
    private long poolCapacity = 0L;
    private long performedWork = 0L;
    private RandomData randomizer = new RandomDataImpl();
    private double resourceCost;
    private TimeUnit elementTimeUnit;
    private TimeGenerator timeGenerator;

    public StaffPoolImpl(String processId, Node element, double simulationDuration) {
        SimulationDataProvider provider = SimulationContext.getContext().getDataProvider();
        this.properties = provider.getSimulationDataForNode(element);
        this.timeGenerator = TimeGeneratorFactory.newTimeGenerator(this.properties);
        this.elementTimeUnit = SimulationUtils.getTimeUnit(this.properties);
        this.poolSize = (int)SimulationUtils.asDouble(this.properties.get("quantity"));
        this.duration = this.timeGenerator.generateTime();
        long workingHoursOpt = (long)SimulationUtils.asDouble(this.properties.get("workinghours"));
        if (workingHoursOpt > 0L) {
            this.workingHours = this.timeUnit.convert(workingHoursOpt, TimeUnit.HOURS);
        }
        this.poolCapacity = (long)this.poolSize * this.workingHours;
        if (simulationDuration > 1.0) {
            this.poolCapacity = (long)((double)this.poolCapacity * simulationDuration);
        }
        this.resourceCost = SimulationUtils.asDouble(this.properties.get("unitcost"));
    }

    protected long allocate(long startTime, long duration) {
        long waitTime = 0L;
        this.performedWork += duration;
        if (this.allocatedTill.size() < this.poolSize) {
            this.allocatedTill.add(startTime + duration);
            return waitTime;
        }
        Collections.sort(this.allocatedTill);
        long allocated = this.allocatedTill.get(0);
        if (allocated >= startTime) {
            waitTime = allocated - startTime;
            allocated += duration;
        } else {
            allocated = startTime + duration;
        }
        this.allocatedTill.set(0, allocated);
        return waitTime;
    }

    public long allocate(long startTime) {
        return this.allocate(startTime, this.duration);
    }

    public long allocate(long startTime, Node element) {
        long duration = this.duration = this.timeGenerator.generateTime();
        return this.allocate(startTime, duration);
    }

    public double getResourceUtilization() {
        return this.performedWork * 100L / this.poolCapacity;
    }

    public double getResourceCost() {
        return this.resourceCost;
    }

    public TimeUnit getElementTimeUnit() {
        return this.elementTimeUnit;
    }
}

