/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.time;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomDataImpl;
import org.jbpm.simulation.TimeGenerator;
import org.jbpm.simulation.util.SimulationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalTimeGenerator
implements TimeGenerator {
    private Map<String, Object> data;
    private static RandomData generator = new RandomDataImpl();
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public NormalTimeGenerator(Map<String, Object> data) {
        this.data = data;
    }

    @Override
    public long generateTime() {
        TimeUnit tu = SimulationUtils.getTimeUnit(this.data);
        long mean = (long)SimulationUtils.asDouble(this.data.get("mean"));
        mean = this.timeUnit.convert(mean, tu);
        long sdv = (long)SimulationUtils.asDouble(this.data.get("standarddeviation"));
        sdv = this.timeUnit.convert(sdv, tu);
        return (long)generator.nextGaussian((double)mean, (double)sdv);
    }
}

