/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.util;

import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Process;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.jboss.drools.impl.DroolsPackageImpl;
import org.jbpm.simulation.util.JBPMBpmn2ResourceFactoryImpl;
import org.jbpm.simulation.util.JBPMBpmn2ResourceImpl;

public class BPMN2Utils {
    public static Definitions getDefinitions(InputStream is) {
        DroolsPackageImpl.init();
        try {
            EList errors;
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new JBPMBpmn2ResourceFactoryImpl());
            resourceSet.getPackageRegistry().put((Object)"http://www.omg.org/spec/BPMN/20100524/MODEL", (Object)Bpmn2Package.eINSTANCE);
            JBPMBpmn2ResourceImpl resource = (JBPMBpmn2ResourceImpl)resourceSet.createResource(URI.createURI((String)"inputStream://dummyUriWithValidSuffix.xml"));
            resource.getDefaultLoadOptions().put("ENCODING", "UTF-8");
            resource.setEncoding("UTF-8");
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            resource.load(is, options);
            EList warnings = resource.getWarnings();
            if (warnings != null && !warnings.isEmpty()) {
                for (Resource.Diagnostic diagnostic : warnings) {
                    System.out.println("Warning: " + diagnostic.getMessage());
                }
            }
            if ((errors = resource.getErrors()) != null && !errors.isEmpty()) {
                for (Resource.Diagnostic diagnostic : errors) {
                    System.out.println("Error: " + diagnostic.getMessage());
                }
                throw new IllegalStateException("Error parsing process definition");
            }
            return ((DocumentRoot)resource.getContents().get(0)).getDefinitions();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static boolean isAdHoc(FlowElement element) {
        if (element.eContainer() instanceof Process) {
            Process process = (Process)element.eContainer();
            for (FeatureMap.Entry entry : process.getAnyAttribute()) {
                if (!entry.getEStructuralFeature().getName().equals("adHoc")) continue;
                return Boolean.parseBoolean(((String)entry.getValue()).trim());
            }
        } else if (element instanceof AdHocSubProcess) {
            return true;
        }
        return false;
    }

    public static boolean isContainerAdHoc(FlowElementsContainer container) {
        if (container instanceof Process) {
            Process process = (Process)container;
            for (FeatureMap.Entry entry : process.getAnyAttribute()) {
                if (!entry.getEStructuralFeature().getName().equals("adHoc")) continue;
                return Boolean.parseBoolean(((String)entry.getValue()).trim());
            }
        } else if (container instanceof AdHocSubProcess) {
            return true;
        }
        return false;
    }
}

