/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.listener;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.slf4j.Logger;

public class IterableProcessEventListener
implements ProcessEventListener,
Iterator<TrackedEvent> {
    public static final String BEFORE_STARTED = "beforeProcessStarted";
    public static final String AFTER_STARTED = "afterProcessStarted";
    public static final String BEFORE_COMPLETED = "beforeProcessCompleted";
    public static final String AFTER_COMPLETED = "afterProcessCompleted";
    public static final String BEFORE_TRIGGERED = "beforeNodeTriggered";
    public static final String AFTER_TRIGGERED = "afterNodeTriggered";
    public static final String BEFORE_LEFT = "beforeNodeLeft";
    public static final String AFTER_LEFT = "afterNodeLeft";
    public static final String BEFORE_VARIABLE = "beforeVariableChanged";
    public static final String AFTER_VARIABLE = "afterVariableChanged";
    private final List<TrackedEvent> events = new LinkedList<TrackedEvent>();
    private int position = 0;

    public void beforeProcessStarted(ProcessStartedEvent event) {
        this.events.add(new TrackedEvent(new CachedProcessStartedEvent(event), BEFORE_STARTED));
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        this.events.add(new TrackedEvent(new CachedProcessCompletedEvent(event), BEFORE_COMPLETED));
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        this.events.add(new TrackedEvent(new CachedProcessNodeTriggeredEvent(event), BEFORE_TRIGGERED));
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        this.events.add(new TrackedEvent(new CachedProcessNodeLeftEvent(event), BEFORE_LEFT));
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        this.events.add(new TrackedEvent(new CachedProcessVariableChangedEvent(event), BEFORE_VARIABLE));
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        this.events.add(new TrackedEvent(new CachedProcessVariableChangedEvent(event), AFTER_VARIABLE));
    }

    @Override
    public boolean hasNext() {
        return this.position < this.events.size();
    }

    @Override
    public TrackedEvent next() {
        return this.events.get(this.position++);
    }

    public TrackedEvent current() {
        return this.events.get(this.position == 0 ? 0 : this.position - 1);
    }

    @Override
    public void remove() {
    }

    public void reset() {
        this.position = 0;
    }

    public void clear() {
        this.reset();
        this.events.clear();
    }

    public void printCurrentState() {
        this.printState(null, true);
    }

    public void printCurrentState(Logger logger) {
        this.printState(logger, true);
    }

    public void printRemainingEvents() {
        this.printState(null, false);
    }

    public void printRemainingEvents(Logger logger) {
        this.printState(logger, false);
    }

    private void printState(Logger logger, boolean reset) {
        int mark = this.position;
        if (reset) {
            this.reset();
        }
        if (logger == null) {
            this.printToStdOut();
        } else {
            this.printToLogger(logger);
        }
        this.position = mark;
    }

    private void printToStdOut() {
        while (this.hasNext()) {
            System.out.println(this.next().toString());
        }
    }

    private void printToLogger(Logger logger) {
        while (this.hasNext()) {
            logger.info(this.next().toString());
        }
    }

    public static class CachedProcessVariableChangedEvent
    extends NoopProcessEvent
    implements ProcessVariableChangedEvent {
        private final String variableId;
        private final String variableInstanceId;
        private final Object oldValue;
        private final Object newValue;

        public CachedProcessVariableChangedEvent(ProcessVariableChangedEvent event) {
            super((ProcessEvent)event);
            this.variableId = event.getVariableId();
            this.variableInstanceId = event.getVariableInstanceId();
            this.oldValue = event.getOldValue();
            this.newValue = event.getNewValue();
        }

        public String getVariableId() {
            return this.variableId;
        }

        public String getVariableInstanceId() {
            return this.variableInstanceId;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public String toString() {
            return this.variableId + ":" + (this.oldValue == null ? "null" : this.oldValue.toString()) + " -> " + (this.newValue == null ? "null" : this.newValue.toString());
        }
    }

    public static class CachedProcessCompletedEvent
    extends NoopProcessEvent
    implements ProcessCompletedEvent {
        public CachedProcessCompletedEvent(ProcessCompletedEvent event) {
            super((ProcessEvent)event);
        }

        @Override
        public String getProcessId() {
            return this.processId;
        }

        public String toString() {
            return this.processId + " completed";
        }
    }

    public static class CachedProcessNodeLeftEvent
    extends NoopProcessEvent
    implements ProcessNodeLeftEvent {
        private final String nodeName;

        public CachedProcessNodeLeftEvent(ProcessNodeLeftEvent event) {
            super((ProcessEvent)event);
            this.nodeName = event.getNodeInstance().getNodeName();
        }

        public NodeInstance getNodeInstance() {
            return null;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String toString() {
            return this.nodeName + " left";
        }
    }

    public static class CachedProcessNodeTriggeredEvent
    extends NoopProcessEvent
    implements ProcessNodeTriggeredEvent {
        private final String nodeName;

        public CachedProcessNodeTriggeredEvent(ProcessNodeTriggeredEvent event) {
            super((ProcessEvent)event);
            this.nodeName = event.getNodeInstance().getNodeName();
        }

        public NodeInstance getNodeInstance() {
            return null;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String toString() {
            return this.nodeName + " triggered";
        }
    }

    public static class CachedProcessStartedEvent
    extends NoopProcessEvent
    implements ProcessStartedEvent {
        public CachedProcessStartedEvent(ProcessStartedEvent event) {
            super((ProcessEvent)event);
        }

        @Override
        public String getProcessId() {
            return this.processId;
        }

        public String toString() {
            return this.processId + " started";
        }
    }

    private static class NoopProcessEvent
    implements ProcessEvent {
        protected final String processId;
        protected final long processInstanceId;

        public NoopProcessEvent(ProcessEvent event) {
            this.processId = event.getProcessInstance().getProcessId();
            this.processInstanceId = event.getProcessInstance().getId();
        }

        public KnowledgeRuntime getKieRuntime() {
            return null;
        }

        public ProcessInstance getProcessInstance() {
            return null;
        }

        public String getProcessId() {
            return this.processId;
        }

        public long getProcessInstanceId() {
            return this.processInstanceId;
        }
    }

    public static class TrackedEvent {
        private final NoopProcessEvent event;
        private final String method;

        public TrackedEvent(NoopProcessEvent event, String method) {
            this.event = event;
            this.method = method;
        }

        public <T extends ProcessEvent> T getEvent() {
            return (T)this.event;
        }

        public String getMethod() {
            return this.method;
        }

        public String getProcessId() {
            return this.event.getProcessId();
        }

        public long getProcessInstanceId() {
            return this.event.getProcessInstanceId();
        }

        public String toString() {
            return this.method + "(" + this.event.toString() + ")";
        }
    }
}

