/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.jobexec;

import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.test.JbpmAsyncJobTestCase;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.RequestInfo;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.query.QueryContext;
import qa.tools.ikeeper.annotation.BZ;

public class AsyncTaskTest
extends JbpmAsyncJobTestCase {
    public static final String ASYNC_EXECUTOR = "org/jbpm/test/functional/jobexec/AsyncExecutor.bpmn2";
    public static final String ASYNC_EXECUTOR_ID = "org.jbpm.test.functional.jobexec.AsyncExecutor";
    public static final String ASYNC_DATA_EXECUTOR = "org/jbpm/test/functional/jobexec/AsyncDataExecutor.bpmn2";
    public static final String ASYNC_DATA_EXECUTOR_ID = "org.jbpm.test.functional.jobexec.AsyncDataExecutor";
    public static final String USER_COMMAND = "org.jbpm.test.jobexec.UserCommand";
    public static final String USER_FAILING_COMMAND = "org.jbpm.test.jobexec.UserFailingCommand";

    @Test
    public void testTaskErrorHandling() throws Exception {
        KieSession ksession = this.createKSession(ASYNC_EXECUTOR);
        WorkItemManager wim = ksession.getWorkItemManager();
        wim.registerWorkItemHandler("async", (WorkItemHandler)new AsyncWorkItemHandler(this.getExecutorService()));
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("command", USER_FAILING_COMMAND);
        ProcessInstance pi = ksession.startProcess(ASYNC_EXECUTOR_ID, pm);
        this.assertNodeTriggered(pi.getId(), new String[]{"Start", "Hello", "Task 1"});
        this.assertNodeNotTriggered(pi.getId(), "Output");
        this.assertNodeNotTriggered(pi.getId(), "Runtime Error Handling");
        this.assertNodeNotTriggered(pi.getId(), "Illegal Argument Error Handling");
        Thread.sleep(10000L);
        this.assertNodeTriggered(pi.getId(), new String[]{"Runtime Error Handling", "RuntimeErrorEnd"});
        this.assertNodeNotTriggered(pi.getId(), "Output");
        this.assertNodeNotTriggered(pi.getId(), "Illegal Argument Error Handling");
        Assertions.assertThat((List)this.getExecutorService().getInErrorRequests(new QueryContext())).hasSize(1);
        Assertions.assertThat((String)((ErrorInfo)((RequestInfo)this.getExecutorService().getInErrorRequests(new QueryContext()).get(0)).getErrorInfo().get(0)).getMessage()).isEqualTo((Object)"Internal Error");
        this.assertProcessInstanceCompleted(pi.getId());
    }

    @Test
    @BZ(value={"1121027"})
    public void testTaskComplete() throws Exception {
        KieSession ksession = this.createKSession(ASYNC_DATA_EXECUTOR);
        WorkItemManager wim = ksession.getWorkItemManager();
        wim.registerWorkItemHandler("async", (WorkItemHandler)new AsyncWorkItemHandler(this.getExecutorService()));
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("command", USER_COMMAND);
        ProcessInstance pi = ksession.startProcess(ASYNC_DATA_EXECUTOR_ID, pm);
        this.assertNodeTriggered(pi.getId(), new String[]{"StartProcess", "Set user info", "Process async"});
        this.assertNodeNotTriggered(pi.getId(), "Output");
        Thread.sleep(10000L);
        this.assertNodeTriggered(pi.getId(), new String[]{"Output", "EndProcess"});
        Assertions.assertThat((List)this.getExecutorService().getCompletedRequests(new QueryContext())).hasSize(1);
        this.assertProcessInstanceCompleted(pi.getId());
    }

    @Ignore
    @Test
    public void testTaskFail() throws Exception {
        KieSession ksession = this.createKSession(ASYNC_DATA_EXECUTOR);
        WorkItemManager wim = ksession.getWorkItemManager();
        wim.registerWorkItemHandler("async", (WorkItemHandler)new AsyncWorkItemHandler(this.getExecutorService()));
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("command", USER_FAILING_COMMAND);
        ProcessInstance pi = ksession.startProcess(ASYNC_DATA_EXECUTOR_ID, pm);
        this.assertNodeTriggered(pi.getId(), new String[]{"StartProcess", "Set user info", "Process async"});
        this.assertNodeNotTriggered(pi.getId(), "Output");
        Thread.sleep(10000L);
        this.assertNodeNotTriggered(pi.getId(), "Output");
        Assertions.assertThat((List)this.getExecutorService().getInErrorRequests(new QueryContext())).hasSize(1);
        Assertions.assertThat((int)((RequestInfo)this.getExecutorService().getInErrorRequests(new QueryContext()).get(0)).getExecutions()).isEqualTo(4);
        Assertions.assertThat((String)((ErrorInfo)((RequestInfo)this.getExecutorService().getInErrorRequests(new QueryContext()).get(0)).getErrorInfo().get(0)).getMessage()).isEqualTo((Object)"Internal Error");
        this.assertProcessInstanceActive(pi.getId());
        ksession.abortProcessInstance(pi.getId());
        this.assertProcessInstanceAborted(pi.getId());
    }
}

