/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.subprocess;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;

public class SubprocessesTest
extends JbpmTestCase {
    private static final String P2_START = "Start";
    private static final String P2_GATEWAY_START = "Gateway";
    private static final String P2_GATEWAY_END = "Gateway";
    private static final String P2_SIGNAL_END = "Signal";
    private static final String P2_END = "End";
    private static final String P3_START = "Start";
    private static final String P3_SIGNAL = "Signal";
    private static final String P3_SCRIPT = "Set variable";
    private static final String P3_END = "End";
    private static final String PROCESS_PATH_1 = "org/jbpm/test/functional/subprocess/Subprocesses-first.bpmn";
    private static final String PROCESS_ID_1 = "org.jbpm.test.functional.subprocess.Subprocesses-first";
    private static final String PROCESS_PATH_2 = "org/jbpm/test/functional/subprocess/Subprocesses-second.bpmn2";
    private static final String PROCESS_ID_2 = "org.jbpm.test.functional.subprocess.Subprocesses-second";
    private static final String PROCESS_PATH_3 = "org/jbpm/test/functional/subprocess/Subprocesses-third.bpmn2";
    private static final String PROCESS_ID_3 = "org.jbpm.test.functional.subprocess.Subprocesses-third";
    private static final String HELLO_WORLD_PROCESS = "org/jbpm/test/functional/common/HelloWorldProcess1.bpmn";
    private static final String HELLO_WORLD_PROCESS_ID = "org.jbpm.test.functional.common.HelloWorldProcess1";
    private static final boolean JAVA8 = System.getProperty("java.version").contains("1.8");
    private KieSession ksession;

    public SubprocessesTest() {
        super(false);
    }

    @Before
    public void init() throws Exception {
        this.ksession = this.createKSession(PROCESS_PATH_1, PROCESS_PATH_2, PROCESS_PATH_3, HELLO_WORLD_PROCESS);
    }

    @Test(timeout=30000L)
    public void testEmbedded() {
        TrackingProcessEventListener process = this.runProcess(this.ksession, "embedded");
        Assertions.assertThat((boolean)process.wasProcessCompleted(PROCESS_ID_1)).isTrue();
        Assertions.assertThat((boolean)process.wasNodeTriggered("embedded")).isTrue();
        Assertions.assertThat((boolean)process.wasNodeLeft("embedded")).isTrue();
        Assertions.assertThat((boolean)process.wasNodeLeft("print info")).isTrue();
    }

    @Test(timeout=30000L)
    public void testReusable() {
        TrackingProcessEventListener process = this.runProcess(this.ksession, "external");
        Assertions.assertThat((boolean)process.wasProcessCompleted(PROCESS_ID_1)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(HELLO_WORLD_PROCESS_ID)).isTrue();
    }

    @Test(timeout=30000L)
    public void testMissingProcess() {
        try {
            this.runProcess(this.ksession, "missing");
        }
        catch (RuntimeException ex) {
            Assertions.assertThat((Throwable)ex.getCause()).isNotNull();
            Assertions.assertThat((String)ex.getCause().getMessage()).contains(new CharSequence[]{"Could not find process missingProcess"});
        }
    }

    @Test(timeout=30000L)
    public void testProcessStartFromScript() {
        TrackingProcessEventListener process = this.runProcess(this.ksession, "script");
        Assertions.assertThat((boolean)process.wasProcessCompleted(PROCESS_ID_1)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(HELLO_WORLD_PROCESS_ID)).isTrue();
    }

    @Test(timeout=30000L)
    public void testIndependent() {
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("parameters"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"parameters");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"parameter mapping");
        if (JAVA8) {
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"parameters");
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"undefined", null, (Object)"parameters");
        } else {
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"undefined", null, (Object)"parameters");
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"parameters");
        }
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.signalEvent("continue", null, id);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", (Object)"parameters", (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", (Object)"parameters", (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"parameter mapping");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.signalEvent("finish", null, pi.getId());
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
    }

    @Ignore
    @Test(timeout=30000L)
    public void testIndependentAbort() {
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("parameters"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"parameters");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"parameter mapping");
        if (JAVA8) {
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"parameters");
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"undefined", null, (Object)"parameters");
        } else {
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"undefined", null, (Object)"parameters");
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"parameters");
        }
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.abortProcessInstance(id);
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        process.printRemainingEvents();
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"parameter mapping");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Error");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
    }

    @Test(timeout=30000L)
    public void testIndependentNoWaitForCompletionParentFirst() {
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("nowait"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"nowait");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"don't wait for completion");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"don't wait for completion");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.signalEvent("finish", null, pi.getId());
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        this.ksession.signalEvent("continue", null, id);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
    }

    @Test(timeout=30000L)
    public void testIndependentNoWaitForCompletionSubprocessFirst() {
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("nowait"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"nowait");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"don't wait for completion");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"don't wait for completion");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.signalEvent("continue", null, id);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        this.ksession.signalEvent("finish", null, pi.getId());
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
    }

    @Test(timeout=30000L)
    public void testIndependentNoWaitForCompletionAbortParent() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("nowait"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"nowait");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"don't wait for completion");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"don't wait for completion");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        Assertions.assertThat((boolean)listener.wasProcessStarted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessStarted(PROCESS_ID_3)).isTrue();
        this.ksession.abortProcessInstance(pi.getId());
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_3)).isFalse();
        this.ksession.signalEvent("continue", null, id);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_3)).isTrue();
    }

    @Test(timeout=30000L)
    public void testIndependentNoWaitForCompletionAbortSubprocess() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("nowait"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"nowait");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"don't wait for completion");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"don't wait for completion");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        Assertions.assertThat((boolean)listener.wasProcessStarted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessStarted(PROCESS_ID_3)).isTrue();
        this.ksession.abortProcessInstance(id);
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_2)).isFalse();
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_3)).isTrue();
        this.ksession.signalEvent("finish", null, pi.getId());
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_3)).isTrue();
    }

    @Test(timeout=30000L)
    public void testDependentNoWaitForCompletion() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("dependent-nowait"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"dependent-nowait");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"dependent process that doesn't have to be completed");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"dependent process that doesn't have to be completed");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        Assertions.assertThat((boolean)listener.wasProcessStarted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessStarted(PROCESS_ID_3)).isTrue();
        this.ksession.signalEvent("finish", null, pi.getId());
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_3)).isFalse();
        this.ksession.signalEvent("continue", null, id);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_3)).isTrue();
    }

    @Test(timeout=30000L)
    public void testDependentNoWaitForCompletionAbortSubprocess() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("dependent-nowait"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"dependent-nowait");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"dependent process that doesn't have to be completed");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"dependent process that doesn't have to be completed");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.abortProcessInstance(id);
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_2)).isFalse();
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_3)).isTrue();
        this.ksession.signalEvent("finish", null, pi.getId());
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_3)).isTrue();
    }

    @Test(timeout=30000L)
    public void testDependentNoWaitForCompletionAbortParent() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("dependent-nowait"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"dependent-nowait");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"dependent process that doesn't have to be completed");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"dependent process that doesn't have to be completed");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.abortProcessInstance(pi.getId());
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_3)).isFalse();
        this.ksession.signalEvent("continue", null, id);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_3)).isTrue();
    }

    @Test(timeout=30000L)
    public void testDependent() {
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("dependent"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"dependent");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"dependent process");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        long id = ((IterableProcessEventListener.CachedProcessStartedEvent)process.current().getEvent()).getProcessInstanceId();
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.signalEvent("continue", null, id);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"dependent process");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.signalEvent("finish", null, pi.getId());
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
    }

    @Test(timeout=30000L)
    public void testDependentAbort() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        this.ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("dependent"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"dependent");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"dependent process");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.abortProcessInstance(pi.getId());
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_2)).isFalse();
        Assertions.assertThat((boolean)listener.wasProcessCompleted(PROCESS_ID_3)).isFalse();
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_3)).isTrue();
    }

    @Test(timeout=30000L)
    public void testDependentAbort2() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        this.ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("dependent"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"dependent");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"dependent process");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        long subprocessId = process.current().getProcessInstanceId();
        Assertions.assertThat((long)pi.getId()).isNotEqualTo(subprocessId);
        this.ksession.abortProcessInstance(subprocessId);
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_2)).isTrue();
        Assertions.assertThat((boolean)listener.wasProcessAborted(PROCESS_ID_3)).isTrue();
    }

    @Test(timeout=30000L)
    public void testParameterMapping() {
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("parameters"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"parameters");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"parameter mapping");
        if (JAVA8) {
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"parameters");
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"undefined", null, (Object)"parameters");
        } else {
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"undefined", null, (Object)"parameters");
            IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", null, (Object)"parameters");
        }
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.signalEvent("continue", null);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"variable", (Object)"parameters", (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)P3_SCRIPT);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_3);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", (Object)"parameters", (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"parameter mapping");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.signalEvent("finish", null, pi.getId());
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
    }

    @Test(timeout=30000L)
    public void testVariableScope() {
        IterableProcessEventListener process = new IterableProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = this.ksession.startProcess(PROCESS_ID_2, this.createBranchDefiningMap("variables"));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", null, (Object)"variables");
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"variables scope");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Script");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Script");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"9:variable", null, (Object)"variables");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)process, (String)"node", (Object)"variables", (Object)"new value");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"variables scope");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"Gateway");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)process, (String)"Signal");
        this.ksession.signalEvent("finish", null, pi.getId());
        IterableListenerAssert.assertLeft((IterableProcessEventListener)process, (String)"Signal");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)process, (String)"End");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)process, (String)PROCESS_ID_2);
    }

    private TrackingProcessEventListener runProcess(KieSession session, String processId, String nodeType, Command<?> ... additionalCommands) {
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        session.addEventListener((ProcessEventListener)process);
        ProcessInstance pi = session.startProcess(processId);
        session.signalEvent("nodeType", (Object)nodeType, pi.getId());
        for (Command<?> additionalCommand : additionalCommands) {
            session.execute(additionalCommand);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            this.logger.warn("Interrupted", (Throwable)ex);
        }
        return process;
    }

    private TrackingProcessEventListener runProcess(KieSession session, String nodeType) {
        return this.runProcess(session, PROCESS_ID_1, nodeType, new Command[0]);
    }

    private Map<String, Object> createBranchDefiningMap(String branch) {
        HashMap<String, Object> processVariables = new HashMap<String, Object>();
        processVariables.put("node", branch);
        return processVariables;
    }
}

