/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.util.Arrays;
import java.util.Collection;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;

@RunWith(value=Parameterized.class)
public class ExceptionAfterTimerNodeTest
extends JbpmTestCase {
    private final boolean useQuartz;

    @Parameterized.Parameters(name="Use quartz scheduler={0}")
    public static Collection<Object[]> parameters() {
        Object[][] locking = new Object[][]{{true}, {false}};
        return Arrays.asList(locking);
    }

    public ExceptionAfterTimerNodeTest(boolean useQuartz) {
        super(true, true);
        this.useQuartz = useQuartz;
    }

    @Before
    public void setup() {
        if (this.useQuartz) {
            System.setProperty("org.quartz.properties", "quartz-ram.properties");
        }
    }

    @After
    public void cleanup() {
        System.clearProperty("org.quartz.properties");
    }

    @Test
    public void testExceptionAfterTimer() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/timer/ExceptionAfterTimer.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ProcessInstance pi = ksession.startProcess("com.bpms.customer.RuntimeExceptionAfterTimer");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        pi = ksession.getProcessInstance(pi.getId());
        ExceptionAfterTimerNodeTest.assertNull((Object)pi);
    }
}

