/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.util.Arrays;
import java.util.Collection;
import javax.persistence.Persistence;
import org.jbpm.process.core.timer.impl.QuartzSchedulerService;
import org.jbpm.test.functional.timer.GlobalTimerServiceBaseTest;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;

@RunWith(value=Parameterized.class)
public class GlobalQuartzRAMTimerServiceTest
extends GlobalTimerServiceBaseTest {
    private int managerType;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{1}, {2}, {3}};
        return Arrays.asList(data);
    }

    public GlobalQuartzRAMTimerServiceTest(int managerType) {
        this.managerType = managerType;
    }

    @Before
    public void setUp() {
        GlobalQuartzRAMTimerServiceTest.tearDownOnce();
        GlobalQuartzRAMTimerServiceTest.setUpOnce();
        GlobalQuartzRAMTimerServiceTest.cleanupSingletonSessionId();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.test.persistence");
        System.setProperty("org.quartz.properties", "quartz-ram.properties");
        this.globalScheduler = new QuartzSchedulerService();
        ((QuartzSchedulerService)this.globalScheduler).forceShutdown();
    }

    @After
    public void tearDown() {
        try {
            this.globalScheduler.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanup();
        GlobalQuartzRAMTimerServiceTest.tearDownOnce();
    }

    @Override
    protected RuntimeManager getManager(RuntimeEnvironment environment, boolean waitOnStart) {
        RuntimeManager manager = null;
        if (this.managerType == 1) {
            manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        } else if (this.managerType == 2) {
            manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        } else if (this.managerType == 3) {
            manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        } else {
            throw new IllegalArgumentException("Invalid runtime maanger type");
        }
        if (waitOnStart) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return manager;
    }
}

