/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.test.functional.timer.TimerBaseTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleTimerServicesTest
extends TimerBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(MultipleTimerServicesTest.class);
    private RuntimeEnvironment environmentM1;
    private RuntimeEnvironment environmentM2;
    private RuntimeManager managerM1;
    private RuntimeManager managerM2;
    private int managerType = 1;
    private EntityManagerFactory emf;
    private EntityManagerFactory emf2;

    protected RuntimeManager getManager(RuntimeEnvironment environment, String id) {
        if (this.managerType == 1) {
            return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, id);
        }
        if (this.managerType == 2) {
            return RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, id);
        }
        throw new IllegalArgumentException("Invalid runtime maanger type");
    }

    @Before
    public void setup() {
        System.setProperty("org.quartz.properties", "quartz-db.properties");
        this.testCreateQuartzSchema();
        MultipleTimerServicesTest.cleanupSingletonSessionId();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.test.persistence");
        this.emf2 = Persistence.createEntityManagerFactory((String)"org.jbpm.test.persistence");
    }

    @After
    public void cleanup() {
        System.clearProperty("org.quartz.properties");
        this.managerM1.close();
        this.managerM2.close();
        EntityManagerFactory emf = ((SimpleRuntimeEnvironment)this.environmentM1).getEmf();
        if (emf != null) {
            emf.close();
        }
        if ((emf = ((SimpleRuntimeEnvironment)this.environmentM2).getEmf()) != null && emf.isOpen()) {
            emf.close();
        }
    }

    @Test
    public void testGlobalTimerServiceOnIndependentSingletonManager() throws Exception {
        this.managerType = 1;
        this.testGlobalTimerServiceOnIndependentManager();
    }

    @Test
    public void testGlobalTimerServiceOnIndependentProcessInstanceManager() throws Exception {
        this.managerType = 2;
        this.testGlobalTimerServiceOnIndependentManager();
    }

    public void testGlobalTimerServiceOnIndependentManager() throws Exception {
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listenerM1 = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    logger.debug("On manager 1");
                    timerExporations.add(event.getProcessInstance().getId());
                }
            }
        };
        final ArrayList timerExporations2 = new ArrayList();
        DefaultProcessEventListener listenerM2 = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    logger.debug("On manager 2");
                    timerExporations2.add(event.getProcessInstance().getId());
                }
            }
        };
        this.environmentM1 = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, (ProcessEventListener)listenerM1)).get();
        this.environmentM2 = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf2).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, (ProcessEventListener)listenerM2)).get();
        this.managerM1 = this.getManager(this.environmentM1, "one");
        RuntimeEngine runtimeM1 = this.managerM1.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksessionM1 = runtimeM1.getKieSession();
        this.managerM2 = this.getManager(this.environmentM2, "two");
        RuntimeEngine runtimeM2 = this.managerM2.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksessionM2 = runtimeM2.getKieSession();
        ProcessInstance processInstanceM1 = ksessionM1.startProcess("IntermediateCatchEvent");
        MultipleTimerServicesTest.assertTrue((processInstanceM1.getState() == 1 ? 1 : 0) != 0);
        ProcessInstance processInstanceM2 = ksessionM2.startProcess("IntermediateCatchEvent");
        MultipleTimerServicesTest.assertTrue((processInstanceM2.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1500L);
        this.managerM1.disposeRuntimeEngine(runtimeM1);
        this.managerM2.disposeRuntimeEngine(runtimeM2);
        Thread.sleep(2000L);
        try {
            runtimeM1 = this.managerM1.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceM1.getId()));
            ksessionM1 = runtimeM1.getKieSession();
            processInstanceM1 = ksessionM1.getProcessInstance(processInstanceM1.getId());
            MultipleTimerServicesTest.assertNull((Object)processInstanceM1);
        }
        catch (SessionNotFoundException e) {
            // empty catch block
        }
        try {
            runtimeM2 = this.managerM2.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceM2.getId()));
            ksessionM2 = runtimeM2.getKieSession();
            processInstanceM2 = ksessionM2.getProcessInstance(processInstanceM2.getId());
            MultipleTimerServicesTest.assertNull((Object)processInstanceM2);
        }
        catch (SessionNotFoundException e) {
            // empty catch block
        }
        Thread.sleep(3000L);
        this.managerM1.disposeRuntimeEngine(runtimeM1);
        this.managerM2.disposeRuntimeEngine(runtimeM2);
        MultipleTimerServicesTest.assertEquals((long)3L, (long)timerExporations.size());
        MultipleTimerServicesTest.assertEquals((long)3L, (long)timerExporations2.size());
    }

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }
}

