/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;

public class TrackingProcessEventListener
extends DefaultProcessEventListener {
    private final List<String> processesStarted = new ArrayList<String>();
    private final List<String> processesCompleted = new ArrayList<String>();
    private final List<String> processesAborted = new ArrayList<String>();
    private final List<String> nodesTriggered = new ArrayList<String>();
    private final List<String> nodesLeft = new ArrayList<String>();
    private final List<String> variablesChanged = new ArrayList<String>();

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        this.nodesTriggered.add(event.getNodeInstance().getNodeName());
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        this.nodesLeft.add(event.getNodeInstance().getNodeName());
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        this.processesStarted.add(event.getProcessInstance().getProcessId());
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        if (event.getProcessInstance().getState() == 3) {
            this.processesAborted.add(event.getProcessInstance().getProcessId());
        } else {
            this.processesCompleted.add(event.getProcessInstance().getProcessId());
        }
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        this.variablesChanged.add(event.getVariableId());
    }

    public List<String> getNodesTriggered() {
        return Collections.unmodifiableList(this.nodesTriggered);
    }

    public List<String> getNodesLeft() {
        return Collections.unmodifiableList(this.nodesLeft);
    }

    public List<String> getProcessesStarted() {
        return Collections.unmodifiableList(this.processesStarted);
    }

    public List<String> getProcessesCompleted() {
        return Collections.unmodifiableList(this.processesCompleted);
    }

    public List<String> getProcessesAborted() {
        return Collections.unmodifiableList(this.processesAborted);
    }

    public List<String> getVariablesChanged() {
        return Collections.unmodifiableList(this.variablesChanged);
    }

    public boolean wasNodeTriggered(String nodeName) {
        return this.nodesTriggered.contains(nodeName);
    }

    public boolean wasNodeLeft(String nodeName) {
        return this.nodesLeft.contains(nodeName);
    }

    public boolean wasProcessStarted(String processName) {
        return this.processesStarted.contains(processName);
    }

    public boolean wasProcessCompleted(String processName) {
        return this.processesCompleted.contains(processName);
    }

    public boolean wasProcessAborted(String processName) {
        return this.processesAborted.contains(processName);
    }

    public boolean wasVariableChanged(String variableId) {
        return this.variablesChanged.contains(variableId);
    }

    public void clear() {
        this.nodesTriggered.clear();
        this.nodesLeft.clear();
        this.processesStarted.clear();
        this.processesCompleted.clear();
        this.processesAborted.clear();
        this.variablesChanged.clear();
    }
}

