/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.casemgmt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.CaseMgmtService;
import org.jbpm.casemgmt.CaseMgmtUtil;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.domain.Person;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;

public class HumanTaskCaseTest
extends JbpmTestCase {
    private KieSession kieSession;
    private RuntimeEngine runtimeEngine;
    private CaseMgmtService caseMgmtService;
    private TaskService taskService;
    private ProcessInstance casePi;

    @Before
    public void setup() {
        this.addTaskEventListener((TaskLifeCycleEventListener)new DefaultTaskEventListener(){

            public void afterTaskCompletedEvent(TaskEvent event) {
                Task task = event.getTask();
                if (task.getName().equals("Change age and return message")) {
                    Content output = HumanTaskCaseTest.this.taskService.getContentById(task.getTaskData().getOutputContentId().longValue());
                    Map results = (Map)ContentMarshallerHelper.unmarshall((byte[])output.getContent(), (Environment)TaskContentRegistry.get().getMarshallerContext(task).getEnvironment());
                    for (Map.Entry e : results.entrySet()) {
                        HumanTaskCaseTest.this.caseMgmtService.setCaseData(HumanTaskCaseTest.this.casePi.getId(), (String)e.getKey(), e.getValue());
                    }
                }
            }
        });
        this.kieSession = this.createKSession("EmptyCase.bpmn2");
        this.runtimeEngine = this.getRuntimeEngine();
        this.caseMgmtService = new CaseMgmtUtil(this.runtimeEngine);
        this.taskService = this.runtimeEngine.getTaskService();
    }

    @Test(timeout=30000L)
    public void testCaseData() {
        this.casePi = this.caseMgmtService.startNewCase("caseDataHT");
        long pid = this.casePi.getId();
        Person john = new Person("John", 30);
        this.caseMgmtService.setCaseData(pid, "person", (Object)john);
        Map params = new HashMap<String, Person>();
        params.put("person", john);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assertions.assertThat((List)tasks).hasSize(0);
        this.caseMgmtService.createDynamicHumanTask(pid, "Change age and return message", "john", null, null, params);
        tasks = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assertions.assertThat((Long)task.getProcessInstanceId()).isEqualTo(pid);
        Object[] activeTasks = this.caseMgmtService.getActiveTasks(pid);
        Assertions.assertThat((Object[])activeTasks).hasSize(1);
        params = this.taskService.getTaskContent(task.getId().longValue());
        Person p = (Person)params.get("person");
        p.setAge(35);
        Assertions.assertThat((Object)p).isEqualTo((Object)john);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("person", p);
        result.put("message", "age changed to 35");
        this.taskService.start(task.getId().longValue(), "john");
        this.taskService.complete(task.getId().longValue(), "john", result);
        activeTasks = this.caseMgmtService.getActiveTasks(pid);
        Assertions.assertThat((Object[])activeTasks).hasSize(0);
        System.out.println(" ### CASE DATA ### ");
        Map caseData = this.caseMgmtService.getCaseData(pid);
        for (Map.Entry e : caseData.entrySet()) {
            System.out.println((String)e.getKey() + ":" + e.getValue());
        }
        Assertions.assertThat((Map)caseData).containsEntry((Object)"message", (Object)"age changed to 35");
        Assertions.assertThat((Map)caseData).containsEntry((Object)"person", (Object)p);
    }

    @Test(timeout=30000L)
    public void testAbort() {
        ProcessInstance pi = this.caseMgmtService.startNewCase("caseAbort");
        long pid = pi.getId();
        Assertions.assertThat((int)pi.getState()).isEqualTo(1);
        this.kieSession.abortProcessInstance(pid);
        ProcessInstanceLog pil = this.getLogService().findProcessInstance(pid);
        Assertions.assertThat((Integer)pil.getStatus()).isEqualTo(3);
    }
}

