/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.drools.persistence.TransactionSynchronization;
import org.drools.persistence.jta.JtaTransactionManager;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;

public class TrackingProcessEventListener
extends DefaultProcessEventListener {
    private final int numberOfCountDownsNeeded;
    private boolean transactional = true;
    private final List<String> processesStarted = new ArrayList<String>();
    private CountDownLatch processesStartedLatch;
    private final List<String> processesCompleted = new ArrayList<String>();
    private CountDownLatch processesCompletedLatch;
    private final List<String> processesAborted = new ArrayList<String>();
    private CountDownLatch processesAbortedLatch;
    private final List<String> nodesTriggered = new ArrayList<String>();
    private final ConcurrentHashMap<String, CountDownLatch> nodeTriggeredLatchMap = new ConcurrentHashMap();
    private final List<String> nodesLeft = new ArrayList<String>();
    private final ConcurrentHashMap<String, CountDownLatch> nodeLeftLatchMap = new ConcurrentHashMap();
    private final List<String> variablesChanged = new ArrayList<String>();

    public TrackingProcessEventListener(int involvedThreads) {
        this.numberOfCountDownsNeeded = involvedThreads;
        this.processesAbortedLatch = new CountDownLatch(involvedThreads);
        this.processesStartedLatch = new CountDownLatch(involvedThreads);
        this.processesCompletedLatch = new CountDownLatch(involvedThreads);
    }

    public TrackingProcessEventListener() {
        this(1);
    }

    public TrackingProcessEventListener(boolean transactional) {
        this(1);
        this.transactional = transactional;
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        String nodeName = event.getNodeInstance().getNodeName();
        CountDownLatch nodeLatch = this.getNodeTriggeredLatch(nodeName);
        this.nodesTriggered.add(nodeName);
        this.countDown(nodeLatch);
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        String nodeName = event.getNodeInstance().getNodeName();
        CountDownLatch nodeLatch = this.getNodeLeftLatch(nodeName);
        this.nodesLeft.add(nodeName);
        this.countDown(nodeLatch);
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        if (this.processesStartedLatch.getCount() == 0L) {
            this.processesStartedLatch = new CountDownLatch(this.numberOfCountDownsNeeded);
        }
        this.processesStarted.add(event.getProcessInstance().getProcessId());
        this.countDown(this.processesStartedLatch);
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        if (event.getProcessInstance().getState() == 3) {
            this.processesAborted.add(event.getProcessInstance().getProcessId());
            if (this.processesAbortedLatch.getCount() == 0L) {
                this.processesAbortedLatch = new CountDownLatch(this.numberOfCountDownsNeeded);
            }
            this.countDown(this.processesAbortedLatch);
        } else {
            this.processesCompleted.add(event.getProcessInstance().getProcessId());
            if (this.processesCompletedLatch.getCount() == 0L) {
                this.processesCompletedLatch = new CountDownLatch(this.numberOfCountDownsNeeded);
            }
            this.countDown(this.processesCompletedLatch);
        }
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        this.variablesChanged.add(event.getVariableId());
    }

    public List<String> getNodesTriggered() {
        return Collections.unmodifiableList(this.nodesTriggered);
    }

    public List<String> getNodesLeft() {
        return Collections.unmodifiableList(this.nodesLeft);
    }

    public List<String> getProcessesStarted() {
        return Collections.unmodifiableList(this.processesStarted);
    }

    public List<String> getProcessesCompleted() {
        return Collections.unmodifiableList(this.processesCompleted);
    }

    public List<String> getProcessesAborted() {
        return Collections.unmodifiableList(this.processesAborted);
    }

    public List<String> getVariablesChanged() {
        return Collections.unmodifiableList(this.variablesChanged);
    }

    public boolean wasNodeTriggered(String nodeName) {
        return this.nodesTriggered.contains(nodeName);
    }

    public boolean wasNodeLeft(String nodeName) {
        return this.nodesLeft.contains(nodeName);
    }

    public boolean wasProcessStarted(String processName) {
        return this.processesStarted.contains(processName);
    }

    public boolean wasProcessCompleted(String processName) {
        return this.processesCompleted.contains(processName);
    }

    public boolean wasProcessAborted(String processName) {
        return this.processesAborted.contains(processName);
    }

    public boolean wasVariableChanged(String variableId) {
        return this.variablesChanged.contains(variableId);
    }

    public boolean waitForProcessToStart(long milliseconds) throws Exception {
        return this.processesStartedLatch.await(milliseconds, TimeUnit.MILLISECONDS);
    }

    public boolean waitForProcessToComplete(long milliseconds) throws Exception {
        return this.processesCompletedLatch.await(milliseconds, TimeUnit.MILLISECONDS);
    }

    public boolean waitForProcessToAbort(long milliseconds) throws Exception {
        return this.processesAbortedLatch.await(milliseconds, TimeUnit.MILLISECONDS);
    }

    public boolean waitForNodeTobeTriggered(String nodeName, long milliseconds) throws Exception {
        CountDownLatch nodeLatch = this.getNodeTriggeredLatch(nodeName);
        return nodeLatch.await(milliseconds, TimeUnit.MILLISECONDS);
    }

    public boolean waitForNodeToBeLeft(String nodeName, long milliseconds) throws Exception {
        CountDownLatch nodeLatch = this.getNodeLeftLatch(nodeName);
        return nodeLatch.await(milliseconds, TimeUnit.MILLISECONDS);
    }

    private CountDownLatch getNodeTriggeredLatch(String nodeName) {
        return this.getNodeLatch(this.nodeTriggeredLatchMap, nodeName);
    }

    private CountDownLatch getNodeLeftLatch(String nodeName) {
        return this.getNodeLatch(this.nodeLeftLatchMap, nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountDownLatch getNodeLatch(ConcurrentHashMap<String, CountDownLatch> nodeLatchMap, String nodeName) {
        ConcurrentHashMap<String, CountDownLatch> concurrentHashMap = nodeLatchMap;
        synchronized (concurrentHashMap) {
            CountDownLatch nodeLatch = new CountDownLatch(this.numberOfCountDownsNeeded);
            CountDownLatch previousLatch = nodeLatchMap.putIfAbsent(nodeName, nodeLatch);
            if (previousLatch != null) {
                return previousLatch;
            }
            return nodeLatch;
        }
    }

    public void clear() {
        this.nodesTriggered.clear();
        this.nodesLeft.clear();
        this.processesStarted.clear();
        this.processesCompleted.clear();
        this.processesAborted.clear();
        this.variablesChanged.clear();
        this.processesStartedLatch = new CountDownLatch(this.numberOfCountDownsNeeded);
        this.processesAbortedLatch = new CountDownLatch(this.numberOfCountDownsNeeded);
        this.processesCompletedLatch = new CountDownLatch(this.numberOfCountDownsNeeded);
        this.nodeTriggeredLatchMap.clear();
        this.nodeLeftLatchMap.clear();
    }

    protected void countDown(final CountDownLatch latch) {
        try {
            JtaTransactionManager tm = new JtaTransactionManager(null, null, null);
            if (this.transactional && tm != null && tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                tm.registerTransactionSynchronization(new TransactionSynchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        latch.countDown();
                    }
                });
            } else {
                latch.countDown();
            }
        }
        catch (Exception e) {
            latch.countDown();
        }
    }
}

