/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Before;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;

public class JbpmAsyncJobTestCase
extends JbpmTestCase {
    private static final int EXECUTOR_THREADS = 4;
    private static final int EXECUTOR_RETRIES = 3;
    private static final int EXECUTOR_INTERVAL = 1;
    private int executorThreads;
    private int executorRetries;
    private int executorInterval;
    private ExecutorService executorService;

    public JbpmAsyncJobTestCase() {
        this(4, 1);
    }

    public JbpmAsyncJobTestCase(int executorRetries) {
        this(4, executorRetries, 1);
    }

    public JbpmAsyncJobTestCase(int executorThreads, int executorInterval) {
        this(executorThreads, 3, executorInterval);
    }

    public JbpmAsyncJobTestCase(int executorThreads, int executorRetries, int executorInterval) {
        super(true, true);
        this.executorThreads = executorThreads;
        this.executorRetries = executorRetries;
        this.executorInterval = executorInterval;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = this.getExecutorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        try {
            this.executorService.clearAllRequests();
            this.executorService.clearAllErrors();
            this.executorService.destroy();
        }
        finally {
            super.tearDown();
        }
    }

    protected ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
            this.executorService.setThreadPoolSize(this.executorThreads);
            this.executorService.setRetries(this.executorRetries);
            this.executorService.setInterval(this.executorInterval);
            this.executorService.init();
            this.logger.debug("Created ExecutorService with parameters: '" + this.executorThreads + " threads', '" + this.executorRetries + " retries', interval '" + this.executorInterval + "s'");
        }
        return this.executorService;
    }

    public void assertNodeNotTriggered(long processId, String nodeName) {
        boolean triggered = false;
        try {
            this.assertNodeTriggered(processId, new String[]{nodeName});
            triggered = true;
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        if (triggered) {
            Assertions.fail((String)("Node '" + nodeName + "' was triggered."));
        }
    }

    public List<ProcessInstance> startProcess(KieSession kieSession, String processId, int count) {
        ArrayList<ProcessInstance> piList = new ArrayList<ProcessInstance>();
        for (int i = 0; i < count; ++i) {
            ProcessInstance pi = kieSession.startProcess(processId);
            if (pi == null) continue;
            piList.add(pi);
        }
        return piList;
    }

    public List<ProcessInstance> startProcess(KieSession kieSession, String processId, Map<String, Object> parameters, int count) {
        ArrayList<ProcessInstance> processInstanceList = new ArrayList<ProcessInstance>();
        for (int i = 0; i < count; ++i) {
            ProcessInstance processInstance = kieSession.startProcess(processId, parameters);
            processInstanceList.add(processInstance);
        }
        return processInstanceList;
    }

    public void abortProcess(KieSession kieSession, List<ProcessInstance> processInstanceList) {
        for (ProcessInstance processInstance : processInstanceList) {
            this.abortProcess(kieSession, processInstance.getId());
        }
    }

    public void abortProcess(KieSession kieSession, long pid) {
        ProcessInstance processInstance = kieSession.getProcessInstance(pid);
        if (processInstance != null && processInstance.getState() == 1) {
            kieSession.abortProcessInstance(pid);
        }
    }
}

