/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingAgendaEventListener;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.wih.ListWorkItemHandler;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class TransactionsTest
extends JbpmTestCase {
    private static final String TRANSACTIONS = "org/jbpm/test/functional/Transactions.bpmn";
    private static final String TRANSACTIONS_ID = "org.jbpm.test.functional.Transactions";
    private static final String TRANSACTIONS_DRL = "org/jbpm/test/functional/Transactions.drl";
    private static final String HELLO_WORLD = "org/jbpm/test/functional/common/HelloWorldProcess1.bpmn";
    private KieSession ksession;
    private Map<String, ResourceType> resources;

    @Before
    public void init() throws Exception {
        this.resources = new HashMap<String, ResourceType>();
        this.resources.put(TRANSACTIONS, ResourceType.BPMN2);
        this.resources.put(HELLO_WORLD, ResourceType.BPMN2);
        this.resources.put(TRANSACTIONS_DRL, ResourceType.DRL);
        this.ksession = this.createKSession(this.resources);
    }

    @Test(timeout=60000L)
    public void testStartProcessCommit() throws Exception {
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        long processId = this.startProcess(this.ksession);
        Assertions.assertThat((Object)this.ksession.getProcessInstance(processId)).isNotNull();
        Assertions.assertThat((int)this.ksession.getProcessInstance(processId).getState()).isEqualTo(1);
        ut.commit();
        this.ksession = this.restoreKSession(this.resources);
        this.assertProcessInstanceActive(processId);
    }

    @Test(timeout=60000L)
    public void testStartProcessRollback() throws Exception {
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        long processId = this.startProcess(this.ksession);
        this.assertProcessInstanceActive(processId);
        ut.rollback();
        System.out.println(this.ksession.getId() + " " + this.ksession.toString());
        this.ksession = this.restoreKSession(this.resources);
        System.out.println(this.ksession.getId() + " " + this.ksession.toString());
        try {
            ProcessInstance pi = this.ksession.getProcessInstance(processId);
            Assertions.assertThat((Object)pi).isNull();
        }
        catch (NullPointerException npe) {
            this.logger.error("Non-XA database thrown NPE on process started before rollback", (Throwable)npe);
        }
    }

    @Test(timeout=60000L)
    public void testAbortProcessCommit() throws Exception {
        long processId = this.startProcess(this.ksession);
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.assertProcessInstanceActive(processId);
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        this.ksession.abortProcessInstance(processId);
        ut.commit();
        this.ksession = this.restoreKSession(this.resources);
        this.assertProcessInstanceAborted(processId);
    }

    @Test(timeout=60000L)
    public void testAbortProcessRollback() throws Exception {
        long processId = this.startProcess(this.ksession);
        this.assertProcessInstanceActive(processId);
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        this.ksession.abortProcessInstance(processId);
        ut.rollback();
        this.ksession = this.restoreKSession(this.resources);
        this.assertProcessInstanceActive(processId);
    }

    @Test(timeout=60000L)
    public void testScript() throws Exception {
        TrackingProcessEventListener process = new TrackingProcessEventListener(false);
        this.ksession.addEventListener((ProcessEventListener)process);
        long processId = this.startProcess(this.ksession);
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"script", processId);
        Assertions.assertThat((boolean)process.wasNodeLeft("script")).isTrue();
        ut.rollback();
        process.clear();
        this.ksession = this.restoreKSession(this.resources);
        this.ksession.addEventListener((ProcessEventListener)process);
        ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"script", processId);
        String scriptNodeName = "script";
        TransactionsTest.assertTrue((String)("Node '" + scriptNodeName + "' was not left on time!"), (boolean)process.waitForNodeToBeLeft(scriptNodeName, 1000L));
        Assertions.assertThat((int)ut.getStatus()).isEqualTo(0);
        ut.commit();
        Assertions.assertThat((boolean)process.wasNodeLeft(scriptNodeName)).isTrue();
        this.ksession.signalEvent("finish", null, processId);
        TransactionsTest.assertTrue((String)"Process was not completed on time!", (boolean)process.waitForProcessToComplete(1000L));
        this.assertProcessInstanceCompleted(processId);
    }

    @Test(timeout=60000L)
    public void testRuleflowGroup() throws Exception {
        TrackingProcessEventListener process = new TrackingProcessEventListener(false);
        TrackingAgendaEventListener agenda = new TrackingAgendaEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        this.ksession.addEventListener((AgendaEventListener)agenda);
        long processId = this.startProcess(this.ksession);
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"rfg", processId);
        Assertions.assertThat((boolean)process.wasNodeLeft("rfg")).isTrue();
        ut.rollback();
        Thread.sleep(600L);
        process.clear();
        agenda.clear();
        this.ksession = this.restoreKSession(this.resources);
        this.ksession.addEventListener((ProcessEventListener)process);
        this.ksession.addEventListener((AgendaEventListener)agenda);
        this.ksession.fireAllRules();
        Assertions.assertThat((boolean)agenda.isRuleFired("dummyRule")).isFalse();
        agenda.clear();
        process.clear();
        ut = this.getUserTransaction();
        ut.begin();
        String ruleFlowGroupNodeName = "rfg";
        this.ksession.signalEvent("start", (Object)"rfg", processId);
        TransactionsTest.assertTrue((String)("Node '" + ruleFlowGroupNodeName + "' was not left on time!"), (boolean)process.waitForNodeToBeLeft(ruleFlowGroupNodeName, 1000L));
        ut.commit();
        Assertions.assertThat((boolean)process.wasNodeLeft(ruleFlowGroupNodeName)).isTrue();
        this.ksession.signalEvent("finish", null, processId);
        this.ksession.fireAllRules();
        TransactionsTest.assertTrue((String)"Process did not complete on time!", (boolean)process.waitForProcessToComplete(1000L));
        Assertions.assertThat((boolean)agenda.isRuleFired("dummyRule")).isTrue();
        this.assertProcessInstanceCompleted(processId);
    }

    @Test
    public void testTimer() throws Exception {
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        long processId = this.startProcess(this.ksession);
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"timer", processId);
        Assertions.assertThat((boolean)process.wasNodeLeft("timer")).isTrue();
        ut.rollback();
        Thread.sleep(600L);
        process.clear();
        this.ksession = this.restoreKSession(this.resources);
        this.ksession.addEventListener((ProcessEventListener)process);
        ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"timer", processId);
        ut.commit();
        String timerNodeName = "timer";
        TransactionsTest.assertTrue((String)("Node '" + timerNodeName + "' was not left on time!"), (boolean)process.waitForNodeToBeLeft(timerNodeName, 1500L));
        Assertions.assertThat((boolean)process.wasNodeLeft(timerNodeName)).isTrue();
        String finishScriptNodeName = "Finish-Script";
        TransactionsTest.assertTrue((String)("Node '" + finishScriptNodeName + "' was not triggered on time!"), (boolean)process.waitForNodeTobeTriggered(finishScriptNodeName, 1500L));
        this.ksession.signalEvent("finish", null, processId);
        TransactionsTest.assertTrue((String)"Process did not complete on time!", (boolean)process.waitForProcessToComplete(1500L));
        this.assertProcessInstanceCompleted(processId);
    }

    @Test(timeout=60000L)
    public void testUsertask() throws Exception {
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)process);
        ListWorkItemHandler handler = new ListWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        long processId = this.startProcess(this.ksession);
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"usertask", processId);
        Assertions.assertThat((boolean)process.wasNodeLeft("usertask")).isTrue();
        Assertions.assertThat((Iterable)handler.getWorkItems()).hasSize(1);
        ut.rollback();
        process.clear();
        this.ksession = this.restoreKSession(this.resources);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        this.ksession.addEventListener((ProcessEventListener)process);
        ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"usertask", processId);
        ut.commit();
        String lastUserTaskNodeName = "User Task";
        TransactionsTest.assertTrue((String)("Node '" + lastUserTaskNodeName + "' was not left on time!"), (boolean)process.waitForNodeTobeTriggered(lastUserTaskNodeName, 1000L));
        Assertions.assertThat((Iterable)handler.getWorkItems()).hasSize(2);
        Assertions.assertThat((boolean)process.wasNodeLeft("usertask")).isTrue();
        Assertions.assertThat((boolean)process.wasNodeTriggered(lastUserTaskNodeName)).isTrue();
        Assertions.assertThat((boolean)process.wasNodeLeft(lastUserTaskNodeName)).isFalse();
        Assertions.assertThat((boolean)process.wasProcessCompleted("transactions")).isFalse();
    }

    @Test(timeout=60000L)
    public void testForLoop() throws Exception {
        TrackingProcessEventListener process = new TrackingProcessEventListener(false);
        this.ksession.addEventListener((ProcessEventListener)process);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("collection", Arrays.asList("hello world", "25", "false", "1234567891011121314151617181920", ""));
        long processId = this.ksession.startProcess(TRANSACTIONS_ID, params).getId();
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        String forLoopNodeName = "forloop";
        this.ksession.signalEvent("start", (Object)forLoopNodeName, processId);
        TransactionsTest.assertTrue((String)("Node '" + forLoopNodeName + "' was not left on time!"), (boolean)process.waitForNodeToBeLeft(forLoopNodeName, 1000L));
        Assertions.assertThat((boolean)process.wasNodeLeft(forLoopNodeName)).isTrue();
        ut.rollback();
        process.clear();
        this.ksession = this.restoreKSession(this.resources);
        this.ksession.addEventListener((ProcessEventListener)process);
        ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"forloop", processId);
        ut.commit();
        String multipleInstancesNode = "Multiple Instances";
        TransactionsTest.assertTrue((String)"Process did not complete on time!", (boolean)process.waitForNodeToBeLeft(multipleInstancesNode, 1000L));
        Assertions.assertThat((boolean)process.wasNodeLeft(forLoopNodeName)).isTrue();
        Assertions.assertThat((boolean)process.wasNodeLeft(multipleInstancesNode)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted("transactions")).isFalse();
    }

    @Test(timeout=60000L)
    public void testEmbedded() throws Exception {
        TrackingProcessEventListener process = new TrackingProcessEventListener(false);
        this.ksession.addEventListener((ProcessEventListener)process);
        long processId = this.startProcess(this.ksession);
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"embedded", processId);
        TransactionsTest.assertTrue((String)"Node 'embedded' was not left on time!", (boolean)process.waitForNodeToBeLeft("embedded", 1000L));
        Assertions.assertThat((boolean)process.wasNodeLeft("embedded")).isTrue();
        ut.rollback();
        process.clear();
        this.ksession = this.restoreKSession(this.resources);
        this.ksession.addEventListener((ProcessEventListener)process);
        ut = this.getUserTransaction();
        ut.begin();
        this.ksession.signalEvent("start", (Object)"embedded", processId);
        ut.commit();
        TransactionsTest.assertTrue((String)"Node 'embedded' was not left on time!", (boolean)process.waitForNodeToBeLeft("embedded", 1000L));
        Assertions.assertThat((boolean)process.wasNodeLeft("embedded")).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted("transactions")).isFalse();
    }

    private long startProcess(KieSession ksession) {
        return this.startProcess(ksession, null);
    }

    private long startProcess(KieSession ksession, String nodeType) {
        ProcessInstance pi = ksession.startProcess(TRANSACTIONS_ID);
        if (nodeType != null) {
            ksession.signalEvent("start", (Object)nodeType);
        }
        return pi.getId();
    }

    private UserTransaction getUserTransaction() throws Exception {
        UserTransaction tx = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        return tx;
    }

    public KieSession restoreKSession(Map<String, ResourceType> res) {
        this.disposeRuntimeManager();
        this.createRuntimeManager(res);
        return this.getRuntimeEngine().getKieSession();
    }
}

