/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.log;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.jpa.ExecutorJPAAuditService;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.test.JbpmAsyncJobTestCase;
import org.jbpm.test.listener.CountDownAsyncJobListener;
import org.junit.Test;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.runtime.manager.audit.query.ErrorInfoDeleteBuilder;
import qa.tools.ikeeper.annotation.BZ;

public class ExecutorLogCleanTest
extends JbpmAsyncJobTestCase {
    private static final String ASYNC_DATA_EXEC = "org/jbpm/test/functional/common/AsyncDataExecutor.bpmn2";
    private static final String ASYNC_DATA_EXEC_ID = "org.jbpm.test.functional.common.AsyncDataExecutor";
    private static final int EXECUTOR_RETRIES = 1;
    private ExecutorJPAAuditService auditService;

    public ExecutorLogCleanTest() {
        super(1);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.auditService = new ExecutorJPAAuditService(this.getEmf());
        this.auditService.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            this.auditService.clear();
            this.auditService.dispose();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void deleteInfoLogsByStatus() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        KieSession kieSession = this.createKSession(ASYNC_DATA_EXEC);
        WorkItemManager wim = kieSession.getWorkItemManager();
        wim.registerWorkItemHandler("async", (WorkItemHandler)new AsyncWorkItemHandler(this.getExecutorService()));
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("command", "org.jbpm.test.jobexec.UserCommand");
        ProcessInstance pi = kieSession.startProcess(ASYNC_DATA_EXEC_ID, pm);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((List)this.getExecutorService().getCompletedRequests(new QueryContext())).hasSize(1);
        int resultCount = this.auditService.requestInfoLogDeleteBuilder().status(new STATUS[]{STATUS.DONE}).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(1);
        Assertions.assertThat((List)this.getExecutorService().getCompletedRequests(new QueryContext())).hasSize(0);
    }

    @Test
    @BZ(value={"1188702"})
    public void deleteErrorLogsByDate() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(2);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        KieSession ksession = this.createKSession(ASYNC_DATA_EXEC);
        WorkItemManager wim = ksession.getWorkItemManager();
        wim.registerWorkItemHandler("async", (WorkItemHandler)new AsyncWorkItemHandler(this.getExecutorService()));
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("command", "org.jbpm.test.jobexec.UserFailingCommand");
        ProcessInstance pi = ksession.startProcess(ASYNC_DATA_EXEC_ID, pm);
        countDownListener.waitTillCompleted();
        List errorList = this.getExecutorService().getAllErrors(new QueryContext());
        Assertions.assertThat((List)errorList).hasSize(2);
        int resultCount = ((ErrorInfoDeleteBuilder)this.auditService.errorInfoLogDeleteBuilder().date(new Date[]{((ErrorInfo)errorList.get(0)).getTime()})).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(1);
        Assertions.assertThat((List)this.getExecutorService().getAllErrors(new QueryContext())).hasSize(1);
        ksession.abortProcessInstance(pi.getId());
    }
}

