/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.casemgmt;

import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.CaseMgmtUtil;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import qa.tools.ikeeper.annotation.BZ;

public class MilestoneCaseTest
extends JbpmTestCase {
    protected static final String TERMINATE_CASE = "org/jbpm/test/functional/casemgmt/TerminateMilestone.bpmn2";

    @Test(timeout=30000L)
    @BZ(value={"1256700"})
    public void testProcessCompleted() {
        this.addWorkItemHandler("Milestone", (WorkItemHandler)new SystemOutWorkItemHandler());
        KieSession ksession = this.createKSession(TERMINATE_CASE);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        CaseMgmtUtil caseMgmtService = new CaseMgmtUtil(runtimeEngine);
        ProcessInstance pi = caseMgmtService.startNewCase("completeProcess");
        long pid = pi.getId();
        Assertions.assertThat((int)pi.getState()).isEqualTo(1);
        Object[] achievedMilestones = caseMgmtService.getAchievedMilestones(pid);
        Assertions.assertThat((Object[])achievedMilestones).isNullOrEmpty();
        caseMgmtService.triggerAdHocFragment(pid, "Terminate");
        ProcessInstanceLog pil = this.getLogService().findProcessInstance(pid);
        Assertions.assertThat((Integer)pil.getStatus()).isEqualTo(2);
        achievedMilestones = caseMgmtService.getAchievedMilestones(pid);
        Assertions.assertThat((Object[])achievedMilestones).hasSize(1);
        Assertions.assertThat((String)achievedMilestones[0]).isEqualTo((Object)"Terminate");
    }
}

