/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.casemgmt;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.CaseMgmtUtil;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.NodeInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class MultiTaskCaseTest
extends JbpmTestCase {
    protected static final String MULTI_TASK_CASE = "org/jbpm/test/functional/casemgmt/MultiTaskCase.bpmn2";

    @Test(timeout=30000L)
    public void testTriggerTaskTwice() {
        this.addWorkItemHandler("Milestone", (WorkItemHandler)new SystemOutWorkItemHandler());
        KieSession ksession = this.createKSession(MULTI_TASK_CASE);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        CaseMgmtUtil caseMgmtService = new CaseMgmtUtil(runtimeEngine);
        ProcessInstance pi = caseMgmtService.startNewCase("triggerTaskTwice");
        long pid = pi.getId();
        Assertions.assertThat((int)pi.getState()).isEqualTo(1);
        Object[] achievedMilestones = caseMgmtService.getAchievedMilestones(pid);
        Assertions.assertThat((Object[])achievedMilestones).isNullOrEmpty();
        caseMgmtService.triggerAdHocFragment(pid, "T1");
        caseMgmtService.triggerAdHocFragment(pid, "T1");
        caseMgmtService.triggerAdHocFragment(pid, "T1");
        AuditService auditService = this.getLogService();
        List nodes = auditService.findNodeInstances(pid, "_4");
        ArrayList<String> passedNodes = new ArrayList<String>();
        for (NodeInstanceLog nil : nodes) {
            if (nil.getType() != 1) continue;
            System.out.println(nil);
            passedNodes.add(nil.getNodeName());
        }
        Assertions.assertThat(passedNodes).hasSize(3);
        Assertions.assertThat(passedNodes).containsOnly((Object[])new String[]{"T1"});
        caseMgmtService.triggerAdHocFragment(pid, "Terminate");
    }
}

