/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessPersistenceHumanTaskTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ProcessPersistenceHumanTaskTest.class);

    public ProcessPersistenceHumanTaskTest() {
        super(true, true);
    }

    @Test
    public void testProcess() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        logger.debug("Reloading the environemnt to simulate system restart");
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        String taskGroup = "en-UK";
        List list = taskService.getTasksAssignedAsPotentialOwner("john", taskGroup);
        TaskSummary task = (TaskSummary)list.get(0);
        logger.debug("John is executing task " + task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        logger.debug("Reloading the environemnt to simulate system restart once again");
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        String taskUser = "mary";
        list = taskService.getTasksAssignedAsPotentialOwner(taskUser, taskGroup);
        ProcessPersistenceHumanTaskTest.assertTrue((String)("No tasks found for potential owner " + taskUser + "/" + taskGroup), (list.size() > 0 ? 1 : 0) != 0);
        task = (TaskSummary)list.get(0);
        logger.debug("Mary is executing task " + task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactions() throws Exception {
        long processId;
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        try {
            ut.begin();
            ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
            processId = processInstance.getId();
        }
        finally {
            ut.rollback();
        }
        ProcessPersistenceHumanTaskTest.assertNull((Object)ksession.getProcessInstance(processId));
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        ProcessPersistenceHumanTaskTest.assertEquals((long)0L, (long)list.size());
    }
}

