/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional;

import java.util.ArrayList;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;

public class EventListenersTest
extends JbpmTestCase {
    private static final String PROCESS = "org/jbpm/test/functional/EventListeners.bpmn";
    private static final String PROCESS_ID = "org.jbpm.test.functional.EventListeners";
    private KieSession ksession;

    public EventListenersTest() {
        super(false);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ksession = this.createKSession(PROCESS);
    }

    @Test(timeout=60000L)
    public void testClearExecution() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(EventListenersTest.getCommands().newStartProcess(PROCESS_ID));
        commands.add(EventListenersTest.getCommands().newSignalEvent("other-branch", (Object)"hello world!"));
        this.ksession.execute((Command)EventListenersTest.getCommands().newBatchExecution(commands, null));
        EventListenersTest.assertTrue((boolean)listener.wasNodeTriggered("introduction"));
        EventListenersTest.assertFalse((boolean)listener.wasNodeTriggered("script-warning"));
        EventListenersTest.assertTrue((boolean)listener.wasNodeLeft("introduction"));
        EventListenersTest.assertFalse((boolean)listener.wasNodeLeft("script-warning"));
        EventListenersTest.assertTrue((boolean)listener.wasVariableChanged("signalData"));
        EventListenersTest.assertFalse((boolean)listener.wasVariableChanged("stringVariable"));
        EventListenersTest.assertTrue((boolean)listener.wasProcessStarted(PROCESS_ID));
        EventListenersTest.assertTrue((boolean)listener.wasProcessCompleted(PROCESS_ID));
    }

    @Test(timeout=60000L)
    public void testUnfinishedProcess() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(EventListenersTest.getCommands().newStartProcess(PROCESS_ID));
        this.ksession.execute((Command)EventListenersTest.getCommands().newBatchExecution(commands, null));
        EventListenersTest.assertTrue((boolean)listener.wasNodeTriggered("introduction"));
        EventListenersTest.assertTrue((boolean)listener.wasNodeTriggered("split"));
        EventListenersTest.assertTrue((boolean)listener.wasNodeLeft("introduction"));
        EventListenersTest.assertFalse((boolean)listener.wasNodeLeft("xor-gateway"));
        EventListenersTest.assertTrue((boolean)listener.wasProcessStarted(PROCESS_ID));
        EventListenersTest.assertFalse((boolean)listener.wasProcessCompleted(PROCESS_ID));
    }

    @Test(timeout=60000L)
    public void testBadSignal() {
        TrackingProcessEventListener listener = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)listener);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(EventListenersTest.getCommands().newStartProcess(PROCESS_ID));
        commands.add(EventListenersTest.getCommands().newSignalEvent("bad-signal", (Object)"bad signal!"));
        this.ksession.execute((Command)EventListenersTest.getCommands().newBatchExecution(commands, null));
        EventListenersTest.assertTrue((boolean)listener.wasNodeTriggered("introduction"));
        EventListenersTest.assertFalse((boolean)listener.wasNodeTriggered("info"));
        EventListenersTest.assertTrue((boolean)listener.wasNodeLeft("introduction"));
        EventListenersTest.assertFalse((boolean)listener.wasNodeLeft("info"));
        EventListenersTest.assertFalse((boolean)listener.wasVariableChanged("signalData"));
        EventListenersTest.assertFalse((boolean)listener.wasVariableChanged("stringVariable"));
        EventListenersTest.assertTrue((boolean)listener.wasNodeLeft("script-warning"));
        EventListenersTest.assertTrue((boolean)listener.wasProcessStarted(PROCESS_ID));
        EventListenersTest.assertTrue((boolean)listener.wasProcessCompleted(PROCESS_ID));
    }
}

