/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.casemgmt;

import java.util.List;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.CaseMgmtService;
import org.jbpm.casemgmt.CaseMgmtUtil;
import org.jbpm.test.JbpmTestCase;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;

public class HumanTaskRoleCaseTest
extends JbpmTestCase {
    private KieSession kieSession;
    private RuntimeEngine runtimeEngine;
    private CaseMgmtService caseMgmtService;
    private TaskService taskService;
    private ProcessInstance casePi;

    @Before
    public void setup() {
        this.kieSession = this.createKSession("org/jbpm/test/functional/casemgmt/HumanTaskRoleCase.bpmn2");
        this.runtimeEngine = this.getRuntimeEngine();
        this.caseMgmtService = new CaseMgmtUtil(this.runtimeEngine);
        this.taskService = this.runtimeEngine.getTaskService();
    }

    @Test(timeout=30000L)
    public void testCustomRole() {
        this.casePi = this.caseMgmtService.startNewCase("caseDataHT");
        long pid = this.casePi.getId();
        this.caseMgmtService.addUserToRole(pid, "customRole", "admin");
        this.caseMgmtService.addUserToRole(pid, "customRole", "john");
        String selectedUser = this.getRandomUserInTheRole(pid, "customRole");
        this.caseMgmtService.setCaseData(pid, "optUserId", (Object)selectedUser);
        this.caseMgmtService.triggerAdHocFragment(pid, "Optional Human Task");
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner(selectedUser, "en-UK");
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.taskService.start(task.getId().longValue(), selectedUser);
        this.taskService.complete(task.getId().longValue(), selectedUser, null);
    }

    @Test(timeout=30000L)
    public void testCustomRoleOnDynamicTask() {
        this.casePi = this.caseMgmtService.startNewCase("caseDataHT");
        long pid = this.casePi.getId();
        this.caseMgmtService.addUserToRole(pid, "customRole", "john");
        this.caseMgmtService.addUserToRole(pid, "customRole", "mary");
        String selectedUser = this.getRandomUserInTheRole(pid, "customRole");
        this.caseMgmtService.createDynamicHumanTask(pid, "Custom Role Task", selectedUser, null, null, null);
        List tasks = this.taskService.getTasksByProcessInstanceId(pid);
        Assertions.assertThat((List)tasks).hasSize(1);
        Task task = this.taskService.getTaskById(((Long)tasks.get(0)).longValue());
        this.taskService.start(task.getId().longValue(), selectedUser);
        this.taskService.complete(task.getId().longValue(), selectedUser, null);
    }

    private String getRandomUserInTheRole(long pid, String role) {
        String[] users = (String[])this.caseMgmtService.getCaseRoleInstanceNames(pid).get(role);
        Random rand = new Random();
        int n = rand.nextInt(users.length - 1);
        return users[n];
    }
}

