/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.casemgmt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.CaseMgmtService;
import org.jbpm.casemgmt.CaseMgmtUtil;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.domain.Person;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

public class SubprocessCaseTest
extends JbpmTestCase {
    private static final String HUMAN_TASK = "org/jbpm/test/functional/common/HumanTaskWithMultipleActors.bpmn2";
    private static final String HUMAN_TASK_ID = "org.jbpm.test.functional.common.HumanTaskWithMultipleActors";
    private KieSession kieSession;
    private RuntimeEngine runtimeEngine;
    private CaseMgmtService caseMgmtService;
    private TaskService taskService;
    private ProcessInstance casePi;

    @Before
    public void setup() {
        this.addProcessEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                ProcessInstance pi = event.getProcessInstance();
                if (pi.getProcessId().equals(SubprocessCaseTest.HUMAN_TASK_ID)) {
                    List vars = SubprocessCaseTest.this.getLogService().findVariableInstances(pi.getId());
                    for (VariableInstanceLog v : vars) {
                        SubprocessCaseTest.this.caseMgmtService.setCaseData(SubprocessCaseTest.this.casePi.getId(), "org.jbpm.test.functional.common.HumanTaskWithMultipleActors." + v.getVariableId(), (Object)v.getValue());
                    }
                }
            }
        });
        this.kieSession = this.createKSession("EmptyCase.bpmn2", HUMAN_TASK);
        this.runtimeEngine = this.getRuntimeEngine();
        this.caseMgmtService = new CaseMgmtUtil(this.runtimeEngine);
        this.taskService = this.runtimeEngine.getTaskService();
    }

    @Test(timeout=30000L)
    public void testCaseData() {
        this.casePi = this.caseMgmtService.startNewCase("caseDataHT");
        long pid = this.casePi.getId();
        Person john = new Person("John", 30);
        this.caseMgmtService.setCaseData(pid, "person", (Object)john);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("description", "subprocess");
        this.caseMgmtService.createDynamicProcess(pid, HUMAN_TASK_ID, params);
        Object[] activeSubProcesses = this.caseMgmtService.getActiveSubProcesses(pid);
        Assertions.assertThat((Object[])activeSubProcesses).hasSize(1);
        List list = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assertions.assertThat((List)list).hasSize(1);
        TaskSummary task = (TaskSummary)list.get(0);
        this.taskService.start(task.getId().longValue(), "john");
        this.taskService.complete(task.getId().longValue(), "john", null);
        activeSubProcesses = this.caseMgmtService.getActiveSubProcesses(pid);
        Assertions.assertThat((Object[])activeSubProcesses).hasSize(0);
        Map caseData = this.caseMgmtService.getCaseData(pid);
        System.out.println(" ### CASE DATA ### ");
        for (Map.Entry e : caseData.entrySet()) {
            System.out.println((String)e.getKey() + ":" + e.getValue());
        }
        Assertions.assertThat((Map)caseData).containsEntry((Object)"org.jbpm.test.functional.common.HumanTaskWithMultipleActors.description", (Object)"subprocess");
        Assertions.assertThat((Map)caseData).containsEntry((Object)"person", (Object)john);
    }
}

