/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.casemgmt;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.CaseMgmtService;
import org.jbpm.casemgmt.CaseMgmtUtil;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.casemgmt.WorkCaseService;
import org.jbpm.test.wih.InformWorkItemHandler;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.NodeInstanceLog;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

public class WorkCaseTest
extends JbpmTestCase {
    private KieSession kieSession;
    private RuntimeEngine runtimeEngine;
    private CaseMgmtService caseMgmtService;
    private TaskService taskService;
    private AuditService auditService;
    private InformWorkItemHandler iwih;
    private WorkCaseService wcs;

    @Before
    public void setup() {
        this.addWorkItemHandler("Milestone", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.iwih = new InformWorkItemHandler();
        this.addWorkItemHandler("Inform", (WorkItemHandler)this.iwih);
        this.kieSession = this.createKSession("org/jbpm/test/functional/casemgmt/WorkCase.bpmn2");
        this.runtimeEngine = this.getRuntimeEngine();
        this.caseMgmtService = new CaseMgmtUtil(this.runtimeEngine);
        this.iwih.setCaseMgmtService(this.caseMgmtService);
        this.taskService = this.runtimeEngine.getTaskService();
        this.auditService = this.getLogService();
        this.wcs = new WorkCaseService(this.runtimeEngine);
    }

    @Test(timeout=30000L)
    public void testInformingOfInterestedPeople() {
        String responsible = "john";
        long caseId = this.wcs.createWork("Integrate module X into project Y", "Module X working in the project Y by ...", responsible);
        this.wcs.addInformedPerson(caseId, "mary");
        this.wcs.informAbout(caseId, "my message");
        Assertions.assertThat((String)this.iwih.getLastMessage()).isEqualTo((Object)"my message");
        Assertions.assertThat((String)this.iwih.getLastMessageToWhom()).contains(new CharSequence[]{"mary"});
        this.wcs.milestone(caseId, WorkCaseService.WorkCaseMilestones.CLOSE);
    }

    @Test(timeout=30000L)
    public void testProlongDueDate() {
        String responsible = "john";
        long caseId = this.wcs.createWork("Integrate module X into project Y", "Module X working in the project Y by ...", responsible, 1);
        this.wcs.prolongTimeoutTo(caseId, 3);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ProcessInstanceLog pil = this.auditService.findProcessInstance(caseId);
        Assertions.assertThat((Integer)pil.getStatus()).isEqualTo(1);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        pil = this.auditService.findProcessInstance(caseId);
        Assertions.assertThat((Integer)pil.getStatus()).isEqualTo(2);
    }

    @Test(timeout=30000L)
    public void testConsultations() {
        String responsible = "john";
        long caseId = this.wcs.createWork("Integrate module X into project Y", "Module X working in the project Y by ...", responsible, 20);
        String consultant = "mary";
        this.wcs.addConsultant(caseId, consultant);
        this.wcs.consultWith(caseId, consultant);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner(responsible, "en-UK");
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)this.taskService.getTaskById(task.getId().longValue()).getName()).isEqualTo((Object)"Consult work with mary");
        this.taskService.start(task.getId().longValue(), responsible);
        this.taskService.complete(task.getId().longValue(), responsible, null);
        String secondConsultant = "admin";
        this.wcs.addConsultant(caseId, secondConsultant);
        this.wcs.consultWith(caseId, secondConsultant);
        tasks = this.taskService.getTasksAssignedAsPotentialOwner(responsible, "en-UK");
        Assertions.assertThat((List)tasks).hasSize(1);
        task = (TaskSummary)tasks.get(0);
        Assertions.assertThat((String)this.taskService.getTaskById(task.getId().longValue()).getName()).isEqualTo((Object)"Consult work with admin");
        this.taskService.start(task.getId().longValue(), responsible);
        this.taskService.complete(task.getId().longValue(), responsible, null);
        this.wcs.milestone(caseId, WorkCaseService.WorkCaseMilestones.CLOSE);
        Object[] passedNodes = this.getPassedNodes(caseId);
        Assertions.assertThat((Object[])passedNodes).containsSequence((Object[])new String[]{"Consult work with mary", "Consult work with admin", "Milestone: Close"});
    }

    @Test(timeout=30000L)
    public void testCheckResolution() {
        String responsiblePerson = "john";
        long caseId = this.wcs.createWork("Integrate module X into project Y", "Module X working in the project Y by ...", responsiblePerson);
        this.createAndCompleteTask(caseId, "Do it", responsiblePerson, null, responsiblePerson);
        String approver = "mary";
        this.wcs.addApprover(caseId, approver);
        String selectedApprover = this.wcs.getRandomUserInTheRole(caseId, "accountable");
        this.caseMgmtService.setCaseData(caseId, "accountable", (Object)selectedApprover);
        this.wcs.checkResolution(caseId);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner(selectedApprover, "en-UK");
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.taskService.start(task.getId().longValue(), selectedApprover);
        this.taskService.complete(task.getId().longValue(), selectedApprover, null);
        this.wcs.milestone(caseId, WorkCaseService.WorkCaseMilestones.CLOSE);
        Object[] passedNodes = this.getPassedNodes(caseId);
        Assertions.assertThat((Object[])passedNodes).containsSequence((Object[])new String[]{"[Dynamic] Do it", "Check resolution", "Milestone: Close"});
    }

    @Test(timeout=30000L)
    public void testCompleteHistory() {
        Object[] passedNodes;
        String responsiblePerson = "john";
        long caseId = this.wcs.createWork("Integrate module X into project Y", "Module X working in the project Y by ...", responsiblePerson);
        this.createAndCompleteTask(caseId, "Plan it", responsiblePerson, null, responsiblePerson);
        this.wcs.milestone(caseId, WorkCaseService.WorkCaseMilestones.PLANNING_DONE);
        this.createAndCompleteTask(caseId, "Design and implement it", responsiblePerson, null, responsiblePerson);
        String approver = "john";
        this.wcs.addApprover(caseId, approver);
        String selectedApprover = this.wcs.getRandomUserInTheRole(caseId, "accountable");
        this.caseMgmtService.setCaseData(caseId, "accountable", (Object)selectedApprover);
        this.wcs.checkResolution(caseId);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner(selectedApprover, "en-UK");
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.taskService.start(task.getId().longValue(), selectedApprover);
        this.taskService.complete(task.getId().longValue(), selectedApprover, null);
        this.wcs.milestone(caseId, WorkCaseService.WorkCaseMilestones.WORK_DONE);
        this.wcs.milestone(caseId, WorkCaseService.WorkCaseMilestones.CLOSE);
        for (Object n : passedNodes = this.getPassedNodes(caseId)) {
            System.out.println((String)n);
        }
        Assertions.assertThat((Object[])passedNodes).containsSequence((Object[])new String[]{"[Dynamic] Plan it", "Milestone: Planning Done", "[Dynamic] Design and implement it", "Check resolution", "Milestone: Work Done", "Milestone: Close"});
    }

    private void createAndCompleteTask(long caseId, String taskName, String actors, String groupIds, String userId) {
        this.caseMgmtService.createDynamicHumanTask(caseId, taskName, actors, groupIds, null, null);
        List tasks = this.taskService.getTasksAssignedAsPotentialOwner(userId, "en-UK");
        Assertions.assertThat((List)tasks).hasSize(1);
        TaskSummary task = (TaskSummary)tasks.get(0);
        this.taskService.start(task.getId().longValue(), userId);
        this.taskService.complete(task.getId().longValue(), userId, null);
    }

    private String[] getPassedNodes(long caseId) {
        AuditService auditService = this.getLogService();
        List nodes = auditService.findNodeInstances(caseId);
        String[] passedNodes = new String[nodes.size() / 2];
        for (NodeInstanceLog nil : nodes) {
            if (nil.getType() != 1) continue;
            passedNodes[Integer.valueOf((String)nil.getNodeInstanceId()).intValue()] = nil.getNodeName();
        }
        return passedNodes;
    }
}

