/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbpm.process.core.timer.BusinessCalendarImpl;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;

public class HumanTaskReassignmentTest
extends JbpmTestCase {
    private static final String PROCESS_FILE = "org/jbpm/test/functional/task/TaskReassignmentTimeout.bpmn2";
    private static final String PROCESS_ID = "com.bpms.functional.bpmn2.task.TaskReassignmentTimeout";
    private static final String JOHN = "john";
    private static final String MARY = "mary";
    private KieSession ksession;
    private TaskService taskService;
    private RuntimeManager runtimeManager;
    private RuntimeEngine engine;
    final List<Long> list = new ArrayList<Long>();

    public HumanTaskReassignmentTest() {
        super(true, true);
    }

    @Before
    public void init() {
        this.list.clear();
        org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener listener = new org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener(){

            public void afterTaskActivatedEvent(TaskEvent arg0) {
            }

            public void afterTaskAddedEvent(TaskEvent arg0) {
            }

            public void afterTaskClaimedEvent(TaskEvent arg0) {
            }

            public void afterTaskCompletedEvent(TaskEvent arg0) {
            }

            public void afterTaskDelegatedEvent(TaskEvent arg0) {
            }

            public void afterTaskExitedEvent(TaskEvent arg0) {
            }

            public void afterTaskFailedEvent(TaskEvent arg0) {
            }

            public void afterTaskForwardedEvent(TaskEvent arg0) {
            }

            public void afterTaskNominatedEvent(TaskEvent arg0) {
            }

            public void afterTaskReleasedEvent(TaskEvent arg0) {
            }

            public void afterTaskResumedEvent(TaskEvent arg0) {
            }

            public void afterTaskSkippedEvent(TaskEvent arg0) {
            }

            public void afterTaskStartedEvent(TaskEvent arg0) {
            }

            public void afterTaskStoppedEvent(TaskEvent arg0) {
            }

            public void afterTaskSuspendedEvent(TaskEvent arg0) {
            }

            public void beforeTaskActivatedEvent(TaskEvent arg0) {
            }

            public void beforeTaskAddedEvent(TaskEvent arg0) {
            }

            public void beforeTaskClaimedEvent(TaskEvent arg0) {
            }

            public void beforeTaskCompletedEvent(TaskEvent arg0) {
            }

            public void beforeTaskDelegatedEvent(TaskEvent arg0) {
            }

            public void beforeTaskExitedEvent(TaskEvent arg0) {
            }

            public void beforeTaskFailedEvent(TaskEvent arg0) {
            }

            public void beforeTaskForwardedEvent(TaskEvent arg0) {
            }

            public void beforeTaskNominatedEvent(TaskEvent arg0) {
            }

            public void beforeTaskReleasedEvent(TaskEvent arg0) {
            }

            public void beforeTaskResumedEvent(TaskEvent arg0) {
            }

            public void beforeTaskSkippedEvent(TaskEvent arg0) {
            }

            public void beforeTaskStartedEvent(TaskEvent arg0) {
            }

            public void beforeTaskStoppedEvent(TaskEvent arg0) {
            }

            public void beforeTaskSuspendedEvent(TaskEvent arg0) {
            }

            public void beforeTaskUpdatedEvent(TaskEvent event) {
            }

            public void afterTaskUpdatedEvent(TaskEvent event) {
            }

            public void beforeTaskReassignedEvent(TaskEvent event) {
                HumanTaskReassignmentTest.this.list.add(event.getTask().getId());
            }

            public void afterTaskReassignedEvent(TaskEvent event) {
                HumanTaskReassignmentTest.this.list.add(event.getTask().getId());
            }

            public void beforeTaskNotificationEvent(TaskEvent event) {
            }

            public void afterTaskNotificationEvent(TaskEvent event) {
            }

            public void afterTaskInputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
            }

            public void afterTaskOutputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
            }
        };
        this.addTaskEventListener((TaskLifeCycleEventListener)listener);
        this.runtimeManager = this.createRuntimeManager(new String[]{PROCESS_FILE});
        this.engine = this.getRuntimeEngine();
        this.ksession = this.engine.getKieSession();
        this.taskService = this.engine.getTaskService();
    }

    @After
    public void cleanup() {
        this.runtimeManager.disposeRuntimeEngine(this.engine);
        this.runtimeManager.close();
    }

    private void testTimeout(boolean businessHour) throws InterruptedException {
        long pid = this.ksession.startProcess(PROCESS_ID).getId();
        long taskId = (Long)this.taskService.getTasksByProcessInstanceId(pid).get(0);
        String potOwner = this.getTaskPotentialOwner(taskId);
        HumanTaskReassignmentTest.assertEquals((Object)JOHN, (Object)potOwner);
        Thread.sleep(2000L);
        potOwner = this.getTaskPotentialOwner(taskId);
        HumanTaskReassignmentTest.assertEquals((Object)(businessHour ? MARY : JOHN), (Object)potOwner);
        this.ksession.abortProcessInstance(pid);
    }

    @Test
    public void testTimeout() throws InterruptedException {
        this.testTimeout(true);
    }

    @Test
    public void testTimeoutBusinessHour() throws InterruptedException {
        this.configureBusinessCalendar(true);
        this.testTimeout(true);
    }

    @Test
    public void testTimeoutNonBusinessHour() throws InterruptedException {
        this.configureBusinessCalendar(false);
        this.testTimeout(false);
    }

    @Test
    public void testTimeoutWithEventListener() throws InterruptedException {
        this.testTimeout(true);
        HumanTaskReassignmentTest.assertEquals((long)2L, (long)this.list.size());
    }

    private String getTaskPotentialOwner(long taskId) {
        Task task = this.taskService.getTaskById(taskId);
        HumanTaskReassignmentTest.assertNotNull((Object)task);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        HumanTaskReassignmentTest.assertFalse((boolean)potentialOwners.isEmpty());
        return ((OrganizationalEntity)potentialOwners.get(0)).getId();
    }

    private void configureBusinessCalendar(boolean businessHour) {
        Properties configuration = new Properties();
        if (businessHour) {
            Calendar c = Calendar.getInstance();
            c.add(5, -1);
            int dayOfWeek = c.get(7);
            configuration.setProperty("business.start.hour", "0");
            configuration.setProperty("business.end.hour", "24");
            configuration.setProperty("business.hours.per.day", "24");
            configuration.setProperty("business.hours.per.week", "7");
            configuration.setProperty("business.weekend.days", Integer.toString(dayOfWeek));
        } else {
            Date today = new Date();
            Calendar c = Calendar.getInstance();
            c.add(5, 1);
            Date tomorrow = c.getTime();
            String dateFormat = "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            configuration.setProperty("business.holidays", sdf.format(today) + "," + sdf.format(tomorrow));
            configuration.setProperty("business.holiday.date.format", dateFormat);
        }
        BusinessCalendarImpl businessCalendar = new BusinessCalendarImpl(configuration);
        this.ksession.getEnvironment().set("jbpm.business.calendar", (Object)businessCalendar);
    }
}

