/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.subprocess;

import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;

public class EmbeddedSubProcessTest
extends JbpmTestCase {
    private static final String EMBEDDED = "org/jbpm/test/functional/subprocess/EmbeddedSubProcess.bpmn";
    private static final String EMBEDDED_ID = "org.jbpm.test.functional.subprocess.EmbeddedSubProcess";

    public EmbeddedSubProcessTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testProcessWithEmbeddedSubprocess() {
        KieSession kieSession = this.createKSession(EMBEDDED);
        IterableProcessEventListener eventListener = new IterableProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)eventListener);
        kieSession.execute(EmbeddedSubProcessTest.getCommands().newStartProcess(EMBEDDED_ID));
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)eventListener, (String)EMBEDDED_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"ScriptOuter");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"embedded");
        this.logger.debug("inside embedded subprocess");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"sub-start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"ScriptInner");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"sub-end");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"embedded");
        this.logger.debug("outside embedded subprocess");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)eventListener, (String)EMBEDDED_ID);
    }
}

