/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.services.task.wih.util.LocalHTWorkItemHandlerUtil;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.logger.KnowledgeRuntimeLoggerFactory;
import org.kie.internal.task.api.UserGroupCallback;

public class LocalTaskServiceTest
extends JbpmTestCase {
    private static final String HUMAN_TASK = "org/jbpm/test/functional/common/HumanTask.bpmn2";
    private static final String HUMAN_TASK_ID = "org.jbpm.test.functional.common.HumanTask";
    private static final String EVALUATION = "org/jbpm/test/functional/task/Evaluation2.bpmn";
    private static final String EVALUTION_ID = "com.sample.evaluation";
    private static final String TASK_MULTIPLE_ACTORS = "org/jbpm/test/functional/task/HumanTaskMultipleActors.bpmn2";
    private static final String TASK_MULTIPLE_ACTORS_ID = "com.sample.humantask.multipleactors";
    private static final String TASK_SINGLE_TYPE = "org/jbpm/test/functional/task/HumanTaskWithSingleTypeContent.bpmn2";
    private static final String TASK_SINGLE_TYPE_ID = "com.sample.bpmn.hello1";
    private static final String USER_GROUP_RES = "classpath:/usergroups.properties";
    private static final String BUSINESS_ADMINISTRATOR = "Administrator";
    private KieSession kieSession;
    private TaskService taskService;

    public LocalTaskServiceTest() {
        super(true, true);
    }

    @Before
    public void init() throws Exception {
        this.createRuntimeManager(new String[]{HUMAN_TASK, EVALUATION, TASK_MULTIPLE_ACTORS, TASK_SINGLE_TYPE});
        RuntimeEngine re = this.getRuntimeEngine();
        this.kieSession = re.getKieSession();
        this.taskService = LocalHTWorkItemHandlerUtil.registerLocalHTWorkItemHandler((KieSession)this.kieSession, (EntityManagerFactory)this.getEmf(), (UserGroupCallback)new JBossUserGroupCallbackImpl(USER_GROUP_RES));
    }

    @Test
    public void executeTaskCompleteTest() {
        ProcessInstance processInstance = this.kieSession.startProcess(HUMAN_TASK_ID);
        this.assertProcessInstanceActive(processInstance.getId());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"start", "user task"});
        List list = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        this.taskService.start(task.getId().longValue(), "john");
        this.taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"end"});
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    @Test(expected=PermissionDeniedException.class)
    public void executeTaskDelegationTest() {
        ProcessInstance processInstance = this.kieSession.startProcess(HUMAN_TASK_ID);
        this.assertProcessInstanceActive(processInstance.getId());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"start", "user task"});
        List list = this.taskService.getTasksAssignedAsBusinessAdministrator(BUSINESS_ADMINISTRATOR, "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        this.delegateTask(task, "mary", "doctor");
    }

    @Test
    public void executeTaskDelegationByBusinessAdministratorTest() {
        ProcessInstance processInstance = this.kieSession.startProcess(HUMAN_TASK_ID);
        this.assertProcessInstanceActive(processInstance.getId());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"start", "user task"});
        List list = this.taskService.getTasksAssignedAsBusinessAdministrator(BUSINESS_ADMINISTRATOR, "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        this.delegateTask(task, BUSINESS_ADMINISTRATOR, "doctor");
        this.assertNodeTriggered(processInstance.getId(), new String[]{"end"});
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    @Test
    public void groupTaskQueryTest() throws Exception {
        KnowledgeRuntimeLoggerFactory.newConsoleLogger((KieRuntimeEventManager)this.kieSession);
        this.logger.info("### Starting process ###");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("employee", "salaboy");
        ProcessInstance process = this.kieSession.startProcess(EVALUTION_ID, parameters);
        Assert.assertEquals((long)1L, (long)process.getState());
        List salaboysTasks = this.taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        Assert.assertEquals((long)1L, (long)salaboysTasks.size());
        this.taskService.start(((TaskSummary)salaboysTasks.get(0)).getId().longValue(), "salaboy");
        this.taskService.complete(((TaskSummary)salaboysTasks.get(0)).getId().longValue(), "salaboy", null);
        List pmsTasks = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)pmsTasks.size());
        List hrsTasks = this.taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)1L, (long)hrsTasks.size());
    }

    @Test
    public void testMultipleActorsClaimedQuery() {
        HashMap params = new HashMap();
        ProcessInstance pi = this.kieSession.startProcess(TASK_MULTIPLE_ACTORS_ID, params);
        List task1 = this.taskService.getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        LocalTaskServiceTest.assertNotNull((Object)task1);
        LocalTaskServiceTest.assertEquals((long)1L, (long)task1.size());
        System.out.println("krisv's task:" + ((TaskSummary)task1.get(0)).getName());
        this.taskService.claim(((TaskSummary)task1.get(0)).getId().longValue(), "krisv");
        List task2 = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        LocalTaskServiceTest.assertNotNull((Object)task2);
        LocalTaskServiceTest.assertEquals((long)0L, (long)task2.size());
        this.taskService.start(((TaskSummary)task1.get(0)).getId().longValue(), "krisv");
        this.taskService.complete(((TaskSummary)task1.get(0)).getId().longValue(), "krisv", null);
        this.assertProcessInstanceCompleted(pi.getId());
    }

    @Test
    public void testHumanTaskWithSingleTypeContent() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pVar", "sampleValue");
        this.kieSession.startProcess(TASK_SINGLE_TYPE_ID, params);
        List list = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        this.logger.info("John is executing task {}", (Object)task.getName());
        this.taskService.start(task.getId().longValue(), "john");
        Content content = this.taskService.getContentById(this.taskService.getTaskById(task.getId().longValue()).getTaskData().getDocumentContentId());
        byte[] contentbyte = content.getContent();
        Object tmpObject = ContentMarshallerHelper.unmarshall((byte[])contentbyte, (Environment)this.kieSession.getEnvironment());
        LocalTaskServiceTest.assertNotNull((Object)tmpObject);
        LocalTaskServiceTest.assertTrue((boolean)(tmpObject instanceof String));
        LocalTaskServiceTest.assertEquals((Object)"someContent", (Object)tmpObject);
        Map contentMap = this.taskService.getTaskContent(task.getId().longValue());
        LocalTaskServiceTest.assertNotNull((Object)contentMap);
        LocalTaskServiceTest.assertEquals((long)1L, (long)contentMap.size());
        LocalTaskServiceTest.assertTrue((boolean)contentMap.containsKey("Content"));
        String actualContent = (String)contentMap.get("Content");
        LocalTaskServiceTest.assertNotNull((Object)actualContent);
        LocalTaskServiceTest.assertEquals((Object)"someContent", (Object)actualContent);
        this.taskService.complete(task.getId().longValue(), "john", null);
        list = this.taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        this.logger.info("Mary is executing task {}", (Object)task.getName());
        this.taskService.start(task.getId().longValue(), "mary");
        this.taskService.complete(task.getId().longValue(), "mary", null);
    }

    private void delegateTask(TaskSummary task, String businessAdministrator, String delegateTo) {
        this.taskService.delegate(task.getId().longValue(), businessAdministrator, delegateTo);
        this.taskService.start(task.getId().longValue(), delegateTo);
        this.taskService.complete(task.getId().longValue(), delegateTo, null);
    }
}

