/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.services.task.audit.impl.model.BAMTaskSummaryImpl;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.task.api.EventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessPersistenceHumanTaskOnLaneTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ProcessPersistenceHumanTaskOnLaneTest.class);

    public ProcessPersistenceHumanTaskOnLaneTest() {
        super(true, true);
    }

    @Test
    public void testProcess() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskOnLane.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        this.assertProcessInstanceActive(processInstance.getId());
        logger.debug("Reloading the environemnt to simulate system restart");
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskOnLane.bpmn2"});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        String taskUser = "john";
        String locale = "en-UK";
        List list = taskService.getTasksAssignedAsPotentialOwner(taskUser, locale);
        Assert.assertEquals((long)1L, (long)list.size());
        TaskSummary task = (TaskSummary)list.get(0);
        taskService.claim(task.getId().longValue(), taskUser);
        taskService.start(task.getId().longValue(), taskUser);
        taskService.complete(task.getId().longValue(), taskUser, null);
        logger.debug("Reloading the environemnt to simulate system restart once again");
        ArrayList<Status> reservedOnly = new ArrayList<Status>();
        reservedOnly.add(Status.Reserved);
        list = taskService.getTasksAssignedAsPotentialOwnerByStatus(taskUser, reservedOnly, locale);
        Assert.assertEquals((long)1L, (long)list.size());
        task = (TaskSummary)list.get(0);
        taskService.start(task.getId().longValue(), taskUser);
        taskService.complete(task.getId().longValue(), taskUser, null);
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    @Test
    public void testProcessWIthDifferentGroups() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskOnLaneDifferentGroups.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        this.assertProcessInstanceActive(processInstance.getId());
        logger.debug("Reloading the environemnt to simulate system restart");
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskOnLaneDifferentGroups.bpmn2"});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        String taskUser = "manager";
        String locale = "en-UK";
        List list = taskService.getTasksAssignedAsPotentialOwner(taskUser, locale);
        Assert.assertEquals((long)1L, (long)list.size());
        TaskSummary task = (TaskSummary)list.get(0);
        taskService.claim(task.getId().longValue(), taskUser);
        taskService.start(task.getId().longValue(), taskUser);
        taskService.complete(task.getId().longValue(), taskUser, null);
        logger.debug("Reloading the environemnt to simulate system restart once again");
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskOnLane.bpmn2"});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        ArrayList<Status> reservedAndRegistered = new ArrayList<Status>();
        reservedAndRegistered.add(Status.Reserved);
        reservedAndRegistered.add(Status.Ready);
        list = taskService.getTasksAssignedAsPotentialOwnerByStatus(taskUser, reservedAndRegistered, locale);
        Assert.assertEquals((long)0L, (long)list.size());
        taskUser = "john";
        list = taskService.getTasksAssignedAsPotentialOwnerByStatus(taskUser, reservedAndRegistered, locale);
        Assert.assertEquals((long)1L, (long)list.size());
        task = (TaskSummary)list.get(0);
        Assert.assertEquals((Object)Status.Ready, (Object)task.getStatus());
        taskService.claim(task.getId().longValue(), taskUser);
        taskService.start(task.getId().longValue(), taskUser);
        taskService.complete(task.getId().longValue(), taskUser, null);
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    @Test
    public void testProcessWithBAMListener() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskOnLane.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ((EventService)taskService).registerTaskEventListener((Object)new BAMTaskEventListener(true));
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        this.assertProcessInstanceActive(processInstance.getId());
        long task1 = -1L;
        long task2 = -1L;
        logger.debug("Reloading the environemnt to simulate system restart");
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskOnLane.bpmn2"});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        ((EventService)taskService).registerTaskEventListener((Object)new BAMTaskEventListener(true));
        String taskUser = "john";
        String locale = "en-UK";
        List list = taskService.getTasksAssignedAsPotentialOwner(taskUser, locale);
        Assert.assertEquals((long)1L, (long)list.size());
        TaskSummary task = (TaskSummary)list.get(0);
        task1 = task.getId();
        taskService.claim(task.getId().longValue(), taskUser);
        taskService.start(task.getId().longValue(), taskUser);
        taskService.complete(task.getId().longValue(), taskUser, null);
        ArrayList<Status> reservedOnly = new ArrayList<Status>();
        reservedOnly.add(Status.Reserved);
        list = taskService.getTasksAssignedAsPotentialOwnerByStatus(taskUser, reservedOnly, locale);
        Assert.assertEquals((long)1L, (long)list.size());
        task = (TaskSummary)list.get(0);
        task2 = task.getId();
        taskService.start(task.getId().longValue(), taskUser);
        taskService.complete(task.getId().longValue(), taskUser, null);
        this.assertProcessInstanceCompleted(processInstance.getId());
        EntityManager em = this.getEmf().createEntityManager();
        List bamLogs = em.createQuery("from BAMTaskSummaryImpl").getResultList();
        em.close();
        Assert.assertNotNull((Object)bamLogs);
        Assert.assertEquals((long)2L, (long)bamLogs.size());
        ArrayList<Long> taskIdsFromBAM = new ArrayList<Long>();
        for (BAMTaskSummaryImpl bamEntry : bamLogs) {
            taskIdsFromBAM.add(bamEntry.getTaskId());
        }
        Assert.assertTrue((boolean)taskIdsFromBAM.contains(task1));
        Assert.assertTrue((boolean)taskIdsFromBAM.contains(task2));
    }
}

