/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.task;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.TrackingListenerAssert;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import qa.tools.ikeeper.annotation.BZ;

public class HumanTaskTest
extends JbpmTestCase {
    private static final String BOUNDARY_TIMER = "org/jbpm/test/regression/task/HumanTask-boundaryTimer.bpmn2";
    private static final String BOUNDARY_TIMER_ID = "org.jbpm.test.regression.task.HumanTask-boundaryTimer";
    private static final String COMPLETION_ROLLBACK = "org/jbpm/test/regression/task/HumanTask-completionRollback.bpmn2";
    private static final String COMPLETION_ROLLBACK_ID = "org.jbpm.test.regression.task.HumanTask-completionRollback";
    private static final String ON_ENTRY_SCRIPT_EXCEPTION = "org/jbpm/test/regression/task/HumanTask-onEntryScriptException.bpmn2";
    private static final String ON_ENTRY_SCRIPT_EXCEPTION_ID = "org.jbpm.test.regression.task.HumanTask-onEntryScriptException";
    private static final String ON_EXIT_SCRIPT_EXCEPTION = "org/jbpm/test/regression/task/HumanTask-onExitScriptException.bpmn2";
    private static final String ON_EXIT_SCRIPT_EXCEPTION_ID = "org.jbpm.test.regression.task.HumanTask-onExitScriptException";
    private static final String ABORT_WORKITEM_TASK_STATUS = "org/jbpm/test/regression/task/HumanTask-abortWorkItemTaskStatus.bpmn2";
    private static final String ABORT_WORKITEM_TASK_STATUS_ID = "org.jbpm.test.regression.task.HumanTask-abortWorkItemTaskStatus";
    private static final String LOCALE = "org/jbpm/test/regression/task/HumanTask-locale.bpmn2";
    private static final String LOCALE_ID = "org.jbpm.test.regression.task.HumanTask-locale";
    private static final String INPUT_TRANSFORMATION = "org/jbpm/test/regression/task/HumanTask-inputTransformation.bpmn2";
    private static final String INPUT_TRANSFORMATION_ID = "org.jbpm.test.regression.task.HumanTask-inputTransformation";

    @Test
    @BZ(value={"958397"})
    public void testBoundaryTimer() throws Exception {
        this.createRuntimeManager(new String[]{BOUNDARY_TIMER});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        TrackingProcessEventListener tpel = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)tpel);
        ProcessInstance pi = ksession.startProcess(BOUNDARY_TIMER_ID);
        String endNodeName = "End1";
        HumanTaskTest.assertTrue((String)("Node '" + endNodeName + "' was not triggered on time!"), (boolean)tpel.waitForNodeTobeTriggered(endNodeName, 2000L));
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"Script1");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)endNodeName);
        long taskId = (Long)taskService.getTasksByProcessInstanceId(pi.getId()).get(0);
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"Script2");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"End2");
        this.assertProcessInstanceCompleted(pi.getId());
    }

    @Test
    @BZ(value={"1004681"})
    public void testCompletionRollback() {
        this.createRuntimeManager(new String[]{COMPLETION_ROLLBACK});
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        ProcessInstance pi = ksession.startProcess(COMPLETION_ROLLBACK_ID);
        this.logger.debug("Process with id = " + pi.getId() + " has just been started.");
        List taskList = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        long taskId = ((TaskSummary)taskList.get(0)).getId();
        taskService.start(taskId, "john");
        Task task = taskService.getTaskById(taskId);
        this.logger.debug("Actual task status: " + task.getTaskData().getStatus());
        try {
            taskService.complete(taskId, "john", null);
            Assertions.fail((String)"Exception should have been thrown from the process script task.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{COMPLETION_ROLLBACK});
        taskService = this.getRuntimeEngine().getTaskService();
        Status status = taskService.getTaskById(taskId).getTaskData().getStatus();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)status).as("Task completion has not been rolled back!", new Object[0])).isEqualTo((Object)Status.InProgress);
    }

    @Test
    @BZ(value={"1120122"})
    public void testOnEntryScriptException() {
        this.createRuntimeManager(new String[]{ON_ENTRY_SCRIPT_EXCEPTION});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        long pid = ksession.startProcess(ON_ENTRY_SCRIPT_EXCEPTION_ID).getId();
        List tasks = taskService.getTasksByProcessInstanceId(pid);
        Assertions.assertThat((List)tasks).hasSize(1);
        Task task = taskService.getTaskById(((Long)tasks.get(0)).longValue());
        Assertions.assertThat((String)((I18NText)task.getNames().get(0)).getText()).isEqualTo((Object)"Human task 2");
    }

    @Test
    @BZ(value={"1120122"})
    public void testOnExitScriptException() {
        this.createRuntimeManager(new String[]{ON_EXIT_SCRIPT_EXCEPTION});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        long pid = ksession.startProcess(ON_EXIT_SCRIPT_EXCEPTION_ID).getId();
        List tasks = taskService.getTasksByProcessInstanceId(pid);
        Assertions.assertThat((List)tasks).hasSize(1);
        long taskId = (Long)tasks.get(0);
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        tasks = taskService.getTasksByProcessInstanceId(pid);
        Assertions.assertThat((List)tasks).hasSize(2);
        Task task1 = taskService.getTaskById(Math.min((Long)tasks.get(0), (Long)tasks.get(1)));
        Assertions.assertThat((String)((I18NText)task1.getNames().get(0)).getText()).isEqualTo((Object)"Human task 1");
        Assertions.assertThat((Comparable)task1.getTaskData().getStatus()).isEqualTo((Object)Status.Completed);
        Task task2 = taskService.getTaskById(Math.max((Long)tasks.get(0), (Long)tasks.get(1)));
        Assertions.assertThat((String)((I18NText)task2.getNames().get(0)).getText()).isEqualTo((Object)"Human task 2");
        Assertions.assertThat((Comparable)task2.getTaskData().getStatus()).isEqualTo((Object)Status.Reserved);
    }

    @Test
    @BZ(value={"1145046"})
    public void testAbortWorkItemTaskStatus() {
        for (int i = 0; i < 5; ++i) {
            this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "abortWorkItemTaskStatus" + i, new String[]{ABORT_WORKITEM_TASK_STATUS});
            RuntimeEngine runtime = this.getRuntimeEngine();
            KieSession ksession = runtime.getKieSession();
            HashMap params = new HashMap();
            ProcessInstance pi = ksession.startProcess(ABORT_WORKITEM_TASK_STATUS_ID, params);
            TaskService taskService = runtime.getTaskService();
            List list = taskService.getTasksByProcessInstanceId(pi.getId());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                long taskId = (Long)iterator.next();
                Task task = taskService.getTaskById(taskId);
                Assertions.assertThat((Comparable)task.getTaskData().getStatus()).isEqualTo((Object)Status.Exited);
            }
            this.disposeRuntimeManager();
        }
    }

    @Test
    @BZ(value={"1139496"})
    public void testLocale() {
        KieSession ksession = this.createKSession(LOCALE);
        ProcessInstance pi = ksession.startProcess(LOCALE_ID);
        RuntimeEngine engine = this.getRuntimeEngine();
        TaskService taskService = engine.getTaskService();
        List taskList = taskService.getTasksAssignedAsPotentialOwner("john", "ja_JP");
        TaskSummary task = (TaskSummary)taskList.get(0);
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        EntityManagerFactory emf = this.getEmf();
        this.assertProcessInstanceCompleted(pi.getId());
        String language = emf.createEntityManager().createNativeQuery("SELECT language from I18NTEXT WHERE shorttext='\u7a7a\u624b'").getSingleResult().toString();
        Assertions.assertThat((String)language).isEqualTo((Object)"ja_JP");
    }

    @Test
    @BZ(value={"1081508"})
    public void testInputTransformation() {
        KieSession ksession = this.createKSession(INPUT_TRANSFORMATION);
        ProcessInstance pi = ksession.startProcess(INPUT_TRANSFORMATION_ID);
        RuntimeEngine engine = this.getRuntimeEngine();
        TaskService taskService = engine.getTaskService();
        List taskList = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Long taskId = ((TaskSummary)taskList.get(0)).getId();
        taskService.start(taskId.longValue(), "john");
        Map taskById = taskService.getTaskContent(taskId.longValue());
        Assertions.assertThat((Map)taskById).containsEntry((Object)"Input", (Object)"Transformed String");
        taskService.complete(taskId.longValue(), "john", null);
        this.assertProcessInstanceCompleted(pi.getId());
    }
}

