/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;

public class CorrelationKeyTest
extends JbpmTestCase {
    private static final String PROCESS = "org.jbpm.test.functional.CorrelationKey";
    private static final String VARIABLE_ID = "procVar";
    private static final String VARIABLE_VALUE = "procVarValue";
    private static final String SIMPLE_KEY = "mySimpleCorrelationKey";
    private static final List<String> COMPOSED_KEY = Arrays.asList("firstPartOfKey", "secondPartOfKey");
    private CorrelationKeyFactory keyFactory;
    private CorrelationAwareProcessRuntime ksession;

    public void setUp() throws Exception {
        super.setUp();
        this.keyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
        this.ksession = (CorrelationAwareProcessRuntime)this.createKSession("org/jbpm/test/functional/CorrelationKey.bpmn2");
    }

    @Test
    public void testSimpleKey() {
        CorrelationKey key = this.keyFactory.newCorrelationKey(SIMPLE_KEY);
        ProcessInstance processInstance = this.ksession.startProcess(PROCESS, key, null);
        this.assertProcessInstanceActive(processInstance.getId());
        CorrelationKey keyCopy = this.keyFactory.newCorrelationKey(SIMPLE_KEY);
        ProcessInstance processInstanceCopy = this.ksession.getProcessInstance(keyCopy);
        Assertions.assertThat((long)processInstanceCopy.getId()).isEqualTo(processInstance.getId());
    }

    @Test
    public void testMultiValuedKey() {
        CorrelationKey key = this.keyFactory.newCorrelationKey(COMPOSED_KEY);
        ProcessInstance processInstance = this.ksession.startProcess(PROCESS, key, null);
        this.assertProcessInstanceActive(processInstance.getId());
        CorrelationKey keyCopy = this.keyFactory.newCorrelationKey(COMPOSED_KEY);
        ProcessInstance processInstanceCopy = this.ksession.getProcessInstance(keyCopy);
        Assertions.assertThat((long)processInstanceCopy.getId()).isEqualTo(processInstance.getId());
    }

    @Test
    public void testNotUniqueSimpleKey() {
        CorrelationKey key = this.keyFactory.newCorrelationKey(SIMPLE_KEY);
        ProcessInstance processInstance = this.ksession.startProcess(PROCESS, key, null);
        this.assertProcessInstanceActive(processInstance.getId());
        try {
            this.ksession.startProcess(PROCESS, key, null);
            Assertions.fail((String)"Not unique correlation key used. Exception should have been thrown.");
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"already exists"});
        }
    }

    @Test
    public void testNotUniqueMultiValuedKey() {
        CorrelationKey key = this.keyFactory.newCorrelationKey(COMPOSED_KEY);
        ProcessInstance processInstance = this.ksession.startProcess(PROCESS, key, null);
        this.assertProcessInstanceActive(processInstance.getId());
        try {
            this.ksession.startProcess(PROCESS, key, null);
            Assertions.fail((String)"Not unique correlation key used. Exception should have been thrown.");
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            Assertions.assertThat((String)ex.getMessage()).contains(new CharSequence[]{"already exists"});
        }
    }

    @Test
    public void testGetNotExistingSimpleKey() {
        CorrelationKey key = this.keyFactory.newCorrelationKey(SIMPLE_KEY);
        ProcessInstance processInstance = this.ksession.getProcessInstance(key);
        Assertions.assertThat((Object)processInstance).isNull();
    }

    @Test
    public void testGetNotExistingMultiValuedKey() {
        CorrelationKey key = this.keyFactory.newCorrelationKey(COMPOSED_KEY);
        ProcessInstance processInstance = this.ksession.getProcessInstance(key);
        Assertions.assertThat((Object)processInstance).isNull();
    }

    @Test
    public void testStartProcessParametersPassing() {
        CorrelationKey key = this.keyFactory.newCorrelationKey(SIMPLE_KEY);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(VARIABLE_ID, VARIABLE_VALUE);
        ProcessInstance processInstance = this.ksession.startProcess(PROCESS, key, parameters);
        this.assertProcessInstanceActive(processInstance.getId());
        List variables = this.getLogService().findVariableInstances(processInstance.getId());
        Assertions.assertThat((List)variables).isNotEmpty();
        Assertions.assertThat((String)((VariableInstanceLog)variables.get(0)).getVariableId()).isEqualTo((Object)VARIABLE_ID);
        Assertions.assertThat((String)((VariableInstanceLog)variables.get(0)).getValue()).isEqualTo((Object)VARIABLE_VALUE);
    }

    @Test
    public void testCreateProcessInstanceParametersPassing() {
        CorrelationKey key = this.keyFactory.newCorrelationKey(SIMPLE_KEY);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(VARIABLE_ID, VARIABLE_VALUE);
        ProcessInstance processInstance = this.ksession.createProcessInstance(PROCESS, key, parameters);
        this.assertProcessInstanceNeverRun(processInstance.getId());
        List variables = this.getLogService().findVariableInstances(processInstance.getId());
        Assertions.assertThat((List)variables).isNotEmpty();
        Assertions.assertThat((String)((VariableInstanceLog)variables.get(0)).getVariableId()).isEqualTo((Object)VARIABLE_ID);
        Assertions.assertThat((String)((VariableInstanceLog)variables.get(0)).getValue()).isEqualTo((Object)VARIABLE_VALUE);
    }

    @Test
    public void testMultiValuedKeyUniqueButInclusive() {
        CorrelationKey key1 = this.keyFactory.newCorrelationKey(Arrays.asList("ABC", "DEF", "DEF"));
        ProcessInstance processInstance = this.ksession.startProcess(PROCESS, key1, null);
        this.assertProcessInstanceActive(processInstance.getId());
        CorrelationKey key2 = this.keyFactory.newCorrelationKey(Arrays.asList("ABC", "DEF", "GHI"));
        ProcessInstance processInstance2 = this.ksession.startProcess(PROCESS, key2, null);
        this.assertProcessInstanceActive(processInstance2.getId());
    }
}

