/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression;

import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import qa.tools.ikeeper.annotation.BZ;

public class GatewayTest
extends JbpmTestCase {
    private static final String INCLUSIVE_DEFAULT = "org/jbpm/test/regression/Gateway-inclusiveDefault.bpmn2";
    private static final String INCLUSIVE_DEFAULT_ID = "org.jbpm.test.regression.Gateway-inclusiveDefault";
    private static final String XPATH_EVALUATION = "org/jbpm/test/regression/Gateway-xPathEvaluation.bpmn2";
    private static final String XPATH_EVALUATION_ID = "org.jbpm.test.regression.Gateway-xPathEvaluation";

    @Test
    @BZ(value={"1146829"})
    public void testInclusiveGatewayDefaultGate() {
        KieSession ksession = this.createKSession(INCLUSIVE_DEFAULT);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "c");
        ProcessInstance processInstance = ksession.startProcess(INCLUSIVE_DEFAULT_ID, params);
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    @Test
    @BZ(value={"1071000"})
    public void testExclusiveSplitXPathAdvanced() throws Exception {
        KieSession ksession = this.createKSession(XPATH_EVALUATION);
        ksession.getWorkItemManager().registerWorkItemHandler("Email", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        ProcessInstance processInstance = ksession.startProcess(XPATH_EVALUATION_ID, params);
        this.assertProcessInstanceCompleted(processInstance.getId());
    }
}

