/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.util.Arrays;
import java.util.Collection;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;

@RunWith(value=Parameterized.class)
public class ExceptionAfterTimerNodeTest
extends JbpmTestCase {
    private final boolean useQuartz;

    @Parameterized.Parameters(name="Use quartz scheduler={0}")
    public static Collection<Object[]> parameters() {
        Object[][] locking = new Object[][]{{true}, {false}};
        return Arrays.asList(locking);
    }

    public ExceptionAfterTimerNodeTest(boolean useQuartz) {
        super(true, true);
        this.useQuartz = useQuartz;
    }

    @Before
    public void setup() {
        if (this.useQuartz) {
            System.setProperty("org.quartz.properties", "quartz-ram.properties");
        }
    }

    @After
    public void cleanup() {
        System.clearProperty("org.quartz.properties");
    }

    @Test(timeout=10000L)
    public void testExceptionAfterTimer() {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1, true);
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/timer/ExceptionAfterTimer.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance pi = ksession.startProcess("com.bpms.customer.RuntimeExceptionAfterTimer");
        countDownListener.waitTillCompleted();
        pi = ksession.getProcessInstance(pi.getId());
        Assert.assertNotNull((Object)pi);
        ksession.abortProcessInstance(pi.getId());
        pi = ksession.getProcessInstance(pi.getId());
        Assert.assertNull((Object)pi);
    }
}

