/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.subprocess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import qa.tools.ikeeper.annotation.BZ;

public class MultipleInstancesSubprocessTest
extends JbpmTestCase {
    private static final String TIMER_EVENT_PARENT = "org/jbpm/test/regression/subprocess/MultipleInstancesSubprocess-timerEvent-parent.bpmn2";
    private static final String TIMER_EVENT_PARENT_ID = "org.jbpm.test.regression.subprocess.MultipleInstancesSubprocess-timerEvent-parent";
    private static final String TIMER_EVENT_SUBPROCESS1 = "org/jbpm/test/regression/subprocess/MultipleInstancesSubprocess-timerEvent-subprocess1.bpmn2";
    private static final String TIMER_EVENT_SUBPROCESS2 = "org/jbpm/test/regression/subprocess/MultipleInstancesSubprocess-timerEvent-subprocess2.bpmn2";
    private static final String ENTRY_AND_EXIT_SCRIPT_PARENT = "org/jbpm/test/regression/subprocess/MultipleInstancesSubprocess-entryAndExitScript-parent.bpmn2";
    private static final String ENTRY_AND_EXIT_SCRIPT_PARENT_ID = "org.jbpm.test.regression.subprocess.MultipleInstancesSubprocess-entryAndExitScript-parent";
    private static final String ENTRY_AND_EXIT_SCRIPT_SUBPROCESS = "org/jbpm/test/regression/subprocess/MultipleInstancesSubprocess-entryAndExitScript-subprocess.bpmn2";
    private static final String ENTRY_AND_EXIT_SCRIPT_SUBPROCESS_ID = "org.jbpm.test.regression.subprocess.MultipleInstancesSubprocess-entryAndExitScript-subprocess";

    @Test
    @BZ(value={"958390"})
    public void testTimerEvent() throws Exception {
        KieSession ksession = this.createKSession(TIMER_EVENT_PARENT, TIMER_EVENT_SUBPROCESS1, TIMER_EVENT_SUBPROCESS2);
        TrackingProcessEventListener processEvents = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)processEvents);
        HashMap params = new HashMap();
        ArrayList<String> clients = new ArrayList<String>();
        clients.add("A");
        clients.add("B");
        params.put("clients", clients);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(MultipleInstancesSubprocessTest.getCommands().newStartProcess(TIMER_EVENT_PARENT_ID, params));
        ksession.execute((Command)MultipleInstancesSubprocessTest.getCommands().newBatchExecution(commands, null));
        String lastNodeName = "main-end";
        MultipleInstancesSubprocessTest.assertTrue((String)("Node '" + lastNodeName + "' was not triggered on time!"), (boolean)processEvents.waitForNodeTobeTriggered(lastNodeName, 4000L));
        Assertions.assertThat((boolean)processEvents.wasNodeTriggered("main-script1")).isTrue();
        Assertions.assertThat((boolean)processEvents.wasNodeTriggered("main-multiinstance1")).isTrue();
        Assertions.assertThat((boolean)processEvents.wasNodeTriggered("main-script2")).isTrue();
        Assertions.assertThat((boolean)processEvents.wasNodeTriggered("main-multiinstance2")).isTrue();
        Assertions.assertThat((boolean)processEvents.wasNodeTriggered(lastNodeName)).isTrue();
    }

    @Test
    @BZ(value={"1123789"})
    public void testEntryAndExitScript() {
        this.createRuntimeManager(new String[]{ENTRY_AND_EXIT_SCRIPT_PARENT, ENTRY_AND_EXIT_SCRIPT_SUBPROCESS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        ProcessInstance pi = ksession.startProcess(ENTRY_AND_EXIT_SCRIPT_PARENT_ID);
        this.logger.debug("Process with id = " + pi.getId() + " has just been started.");
        List varList = this.getLogService().findVariableInstancesByName("onEntryScriptTriggered", false);
        Assertions.assertThat((List)varList).hasSize(1);
        Assertions.assertThat((Boolean)Boolean.valueOf(((VariableInstanceLog)varList.get(0)).getValue())).isTrue();
        varList = this.getLogService().findVariableInstancesByName("onExitScriptTriggered", false);
        Assertions.assertThat((List)varList).hasSize(1);
        Assertions.assertThat((Boolean)Boolean.valueOf(((VariableInstanceLog)varList.get(0)).getValue())).isTrue();
        List processList = this.getLogService().findProcessInstances(ENTRY_AND_EXIT_SCRIPT_PARENT_ID);
        Assertions.assertThat((List)processList).hasSize(1);
        Assertions.assertThat((Integer)((ProcessInstanceLog)processList.get(0)).getStatus()).isEqualTo(2);
        processList = this.getLogService().findProcessInstances(ENTRY_AND_EXIT_SCRIPT_SUBPROCESS_ID);
        Assertions.assertThat((List)processList).hasSize(2);
        for (ProcessInstanceLog pil : processList) {
            Assertions.assertThat((Integer)pil.getStatus()).isEqualTo(2);
        }
    }
}

