/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.OptimisticLockException;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.hibernate.StaleObjectStateException;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.impl.ThreadPoolSchedulerService;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.functional.timer.TimerBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.UserGroupCallback;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentGlobalTimerServiceTest
extends TimerBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentGlobalTimerServiceTest.class);
    private long maxWaitTime = 60000L;
    private int nbThreadsProcess = 10;
    private int nbThreadsTask = 10;
    private CountDownLatch completedStart = new CountDownLatch(this.nbThreadsProcess);
    private CountDownLatch completedTask = new CountDownLatch(this.nbThreadsTask);
    private int wait = 2;
    private UserGroupCallback userGroupCallback;
    private GlobalSchedulerService globalScheduler;
    private RuntimeManager manager;
    private EntityManagerFactory emf;

    @Before
    public void setup() {
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.globalScheduler = new ThreadPoolSchedulerService(1);
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.test.persistence");
    }

    @After
    public void teardown() {
        this.globalScheduler.shutdown();
        if (this.manager != null) {
            this.manager.close();
        }
        this.emf.close();
    }

    @Test
    public void testSessionPerProcessInstance() throws Exception {
        int i;
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycleWithHT.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = engine.getTaskService();
        Group grouphr = TaskModelProvider.getFactory().newGroup();
        ((InternalOrganizationalEntity)grouphr).setId("HR");
        User mary = TaskModelProvider.getFactory().newUser();
        ((InternalOrganizationalEntity)mary).setId("mary");
        User john = TaskModelProvider.getFactory().newUser();
        ((InternalOrganizationalEntity)john).setId("john");
        ((InternalTaskService)taskService).addGroup(grouphr);
        ((InternalTaskService)taskService).addUser(mary);
        ((InternalTaskService)taskService).addUser(john);
        this.manager.disposeRuntimeEngine(engine);
        for (i = 0; i < this.nbThreadsProcess; ++i) {
            new Thread(new StartProcessPerProcessInstanceRunnable(this.manager, i)).start();
        }
        this.completedStart.await(10000L, TimeUnit.MILLISECONDS);
        for (i = 0; i < this.nbThreadsTask; ++i) {
            new Thread(new CompleteTaskPerProcessInstanceRunnable(this.manager, i)).start();
        }
        if (!this.completedTask.await(this.maxWaitTime, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"Failure, did not finish in time most likely hanging");
        }
        engine = this.manager.getRuntimeEngine(EmptyContext.get());
        AuditService logService = engine.getAuditService();
        List logs = logService.findActiveProcessInstances("IntermediateCatchEvent");
        Assert.assertNotNull((Object)logs);
        for (ProcessInstanceLog log : logs) {
            logger.debug("Left over {}", (Object)log.getProcessInstanceId());
        }
        Assert.assertEquals((long)0L, (long)logs.size());
        logs = logService.findProcessInstances("IntermediateCatchEvent");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)this.nbThreadsProcess, (long)logs.size());
        this.manager.disposeRuntimeEngine(engine);
        logger.debug("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStartProcess(RuntimeEngine runtime) throws Exception {
        SingleSessionCommandService singleSessionCommandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)runtime.getKieSession()).getRunner();
        synchronized (singleSessionCommandService) {
            UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            try {
                ut.begin();
                logger.debug("Starting process on ksession {}", (Object)runtime.getKieSession().getIdentifier());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("x", "R2/PT1S");
                ProcessInstance processInstance = runtime.getKieSession().startProcess("IntermediateCatchEvent", params);
                logger.debug("Started process instance {} on ksession {}", (Object)processInstance.getId(), (Object)runtime.getKieSession().getIdentifier());
                ut.commit();
            }
            catch (Exception ex) {
                ut.rollback();
                throw ex;
            }
        }
    }

    private boolean testCompleteTaskByProcessInstance(RuntimeManager manager, RuntimeEngine runtime, long piId) throws InterruptedException, Exception {
        boolean result = false;
        ArrayList<Status> statusses = new ArrayList<Status>();
        statusses.add(Status.Reserved);
        List tasks = null;
        tasks = runtime.getTaskService().getTasksByStatusByProcessInstanceId(piId, statusses, "en-UK");
        if (tasks.isEmpty()) {
            logger.debug("Task thread found no tasks for piId {}", (Object)piId);
            Thread.sleep(1000L);
        } else {
            long taskId = ((TaskSummary)tasks.get(0)).getId();
            logger.debug("Completing task {} piId {}", (Object)taskId, (Object)piId);
            boolean success = false;
            try {
                runtime.getTaskService().start(taskId, "john");
                success = true;
                if (success) {
                    runtime.getTaskService().complete(taskId, "john", null);
                    logger.debug("Completed task {} piID {}", (Object)taskId, (Object)piId);
                    result = true;
                }
            }
            catch (PermissionDeniedException e) {
                logger.debug("Task thread was too late for starting task {} piId {}", (Object)taskId, (Object)piId);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private boolean testRetryCompleteTaskByProcessInstance(RuntimeManager manager, RuntimeEngine runtime, long piId) throws InterruptedException, Exception {
        boolean result = false;
        ArrayList<Status> statusses = new ArrayList<Status>();
        statusses.add(Status.InProgress);
        List tasks = null;
        tasks = runtime.getTaskService().getTasksByStatusByProcessInstanceId(piId, statusses, "en-UK");
        if (tasks.isEmpty()) {
            logger.debug("Retry : Task thread found no tasks for piId {}", (Object)piId);
            Thread.sleep(1000L);
        } else {
            long taskId = ((TaskSummary)tasks.get(0)).getId();
            logger.debug("Retry : Completing task {} piId {}", (Object)taskId, (Object)piId);
            try {
                runtime.getTaskService().complete(taskId, "john", null);
                logger.debug("Retry : Completed task {} piId {}", (Object)taskId, (Object)piId);
                result = true;
            }
            catch (PermissionDeniedException e) {
                logger.debug("Task thread was too late for starting task {} piId {}", (Object)taskId, (Object)piId);
            }
            catch (Exception e) {
                throw e;
            }
        }
        return result;
    }

    public static boolean checkOptimiticLockException(Throwable e) {
        for (Throwable rootCause = e.getCause(); rootCause != null; rootCause = rootCause.getCause()) {
            if (!(rootCause instanceof OptimisticLockException) && !(rootCause instanceof StaleObjectStateException)) continue;
            return true;
        }
        if (e instanceof InvocationTargetException) {
            return ConcurrentGlobalTimerServiceTest.checkOptimiticLockException(((InvocationTargetException)e).getTargetException());
        }
        return false;
    }

    public class CompleteTaskPerProcessInstanceRunnable
    implements Runnable {
        private RuntimeManager manager;
        private int counter;

        public CompleteTaskPerProcessInstanceRunnable(RuntimeManager manager, int counter) {
            this.manager = manager;
            this.counter = counter;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(ConcurrentGlobalTimerServiceTest.this.wait * 1000 + 1000);
                long processInstanceId = this.counter + 1;
                for (int y = 0; y < ConcurrentGlobalTimerServiceTest.this.wait; ++y) {
                    RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
                    try {
                        ConcurrentGlobalTimerServiceTest.this.testCompleteTaskByProcessInstance(this.manager, runtime, processInstanceId);
                    }
                    catch (Throwable e) {
                        if (ConcurrentGlobalTimerServiceTest.checkOptimiticLockException(e)) {
                            logger.debug("{} retrying for process instance {}", (Object)this.counter, (Object)processInstanceId);
                            this.manager.disposeRuntimeEngine(runtime);
                            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
                            ConcurrentGlobalTimerServiceTest.this.testRetryCompleteTaskByProcessInstance(this.manager, runtime, processInstanceId);
                        }
                        throw e;
                    }
                    this.manager.disposeRuntimeEngine(runtime);
                }
                ConcurrentGlobalTimerServiceTest.this.completedTask.countDown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public class StartProcessPerProcessInstanceRunnable
    implements Runnable {
        private RuntimeManager manager;
        private int counter;

        public StartProcessPerProcessInstanceRunnable(RuntimeManager manager, int counter) {
            this.manager = manager;
            this.counter = counter;
        }

        @Override
        public void run() {
            try {
                RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
                ConcurrentGlobalTimerServiceTest.this.testStartProcess(runtime);
                this.manager.disposeRuntimeEngine(runtime);
                ConcurrentGlobalTimerServiceTest.this.completedStart.countDown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

