/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.async;

import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.wih.FirstErrorWorkItemHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class AsyncThrowSignalTest
extends JbpmTestCase {
    private static Object LOCK = new Object();
    private static final String PROCESS_ATS = "org.jbpm.test.functional.async.AsyncThrowSignal";
    private static final String PROCESS_AICS = "org.jbpm.test.functional.async.AsyncIntermediateCatchSignal";
    private static final String BPMN_ATS = "org/jbpm/test/functional/async/AsyncThrowSignal.bpmn2";
    private static final String BPMN_AICS = "org/jbpm/test/functional/async/AsyncIntermediateCatchSignal.bpmn2";
    private ExecutorService executorService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
        this.executorService.setInterval(1);
        this.executorService.init();
        this.addEnvironmentEntry("ExecutorService", this.executorService);
        this.addWorkItemHandler("SyncError", (WorkItemHandler)new FirstErrorWorkItemHandler());
        this.addProcessEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterProcessCompleted(ProcessCompletedEvent event) {
                Object object = LOCK;
                synchronized (object) {
                    LOCK.notifyAll();
                }
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executorService.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCorrectProcessStateAfterExceptionThrowSignal() {
        KieSession ksession = this.createKSession(BPMN_AICS, BPMN_ATS);
        ProcessInstance pi1 = ksession.startProcess(PROCESS_AICS);
        long pid1 = pi1.getId();
        ProcessInstance pi2 = ksession.startProcess(PROCESS_ATS);
        long pid2 = pi2.getId();
        Object object = LOCK;
        synchronized (object) {
            try {
                LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        pi1 = ksession.getProcessInstance(pid1);
        Assertions.assertThat((Object)pi1).isNull();
        pi2 = ksession.getProcessInstance(pid2);
        Assertions.assertThat((Object)pi2).isNull();
    }
}

