/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.event;

import java.util.HashMap;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.entity.Person;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundaryEventWithOutputSetPersistenceTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(BoundaryEventWithOutputSetPersistenceTest.class);
    private static final String PROCESS_TIMER_FILE_NAME = "org/jbpm/test/functional/event/BoundaryTimerProcessWithOutputSet.bpmn2";
    private static final String PROCESS_NAME = "BoundaryTimerEventProcess";
    private static final String PROCESS_MESSAGE_FILE_NAME = "org/jbpm/test/functional/event/BoundaryMessageProcessWithOutputSet.bpmn2";
    private static final String PROCESS_MESSAGE_NAME = "BoundaryMessageEventProcess";
    private static final String PROCESS_SIGNAL_FILE_NAME = "org/jbpm/test/functional/event/BoundarySignalProcessWithOutputSet.bpmn2";
    private static final String PROCESS_SIGNAL_NAME = "BoundarySignalEventProcess";
    private static final String PROCESS_ERROR_FILE_NAME = "org/jbpm/test/functional/event/BoundaryErrorProcessWithOutputSet.bpmn2";
    private static final String PROCESS_ERROR_NAME = "BoundaryErrorEventProcess";
    private static final String PROCESS_ESCALATION_FILE_NAME = "org/jbpm/test/functional/event/BoundaryEscalationProcessWithOutputSet.bpmn2";
    private static final String PROCESS_ESCALATION_NAME = "BoundaryEscalationEventProcess";
    private static final String PROCESS_COMPENSATION_FILE_NAME = "org/jbpm/test/functional/event/BoundaryCompensationProcessWithOutputSet.bpmn2";
    private static final String PROCESS_COMPENSATION_NAME = "BoundaryCompensationEventProcess";
    private static final String PROCESS_CONDITIONAL_FILE_NAME = "org/jbpm/test/functional/event/BoundaryConditionalProcessWithOutputSet.bpmn2";
    private static final String PROCESS_CONDITIONAL_NAME = "BoundaryConditionalEventProcess";
    private static final String WORK_ITEM_HANDLER_TASK = "Human Task";
    private static final String WORK_ITEM_HANDLER_DATA = "DataCaptureTask";

    public BoundaryEventWithOutputSetPersistenceTest() {
        super(true, true);
    }

    @Test
    public void testBoundaryEventTimerAndCompleteHumanTask() throws InterruptedException {
        this.createRuntimeManager(new String[]{PROCESS_TIMER_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        Assert.assertTrue((String)"session id not saved.", (ksessionId > 0L ? 1 : 0) != 0);
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler();
        DataTaskMockHandler dataTaskMockHandler = new DataTaskMockHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_TASK, (WorkItemHandler)humanTaskMockHandler);
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_DATA, (WorkItemHandler)dataTaskMockHandler);
        ProcessInstance process = ksession.startProcess(PROCESS_NAME);
        long processId = process.getId();
        Assert.assertTrue((String)"process id not saved", (processId > 0L ? 1 : 0) != 0);
        int processState = process.getState();
        Assert.assertEquals((String)("Expected process state to be " + processStateName[1] + " not " + processStateName[processState]), (long)1L, (long)processState);
        this.sleepAndVerifyTimerRuns();
        this.completeWork(ksession, humanTaskMockHandler);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((String)"Expected process to have been completed and removed", (Object)process);
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("nodeInstance") instanceof HumanTaskNodeInstance));
        Assert.assertEquals((Object)dataTaskMockHandler.getInputParameter("event"), (Object)1L);
        Assert.assertEquals((Object)dataTaskMockHandler.getInputParameter("signal"), (Object)"Timer-_2-500ms###1s-4");
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("workItem") instanceof WorkItem));
    }

    @Test
    public void testBoundaryEventMessageAndCompleteHumanTask() throws InterruptedException {
        this.createRuntimeManager(new String[]{PROCESS_MESSAGE_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        Assert.assertTrue((String)"session id not saved.", (ksessionId > 0L ? 1 : 0) != 0);
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler();
        DataTaskMockHandler dataTaskMockHandler = new DataTaskMockHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_TASK, (WorkItemHandler)humanTaskMockHandler);
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_DATA, (WorkItemHandler)dataTaskMockHandler);
        ProcessInstance process = ksession.startProcess(PROCESS_MESSAGE_NAME);
        long processId = process.getId();
        Assert.assertTrue((String)"process id not saved", (processId > 0L ? 1 : 0) != 0);
        int processState = process.getState();
        Assert.assertEquals((String)("Expected process state to be " + processStateName[1] + " not " + processStateName[processState]), (long)1L, (long)processState);
        ksession.signalEvent("Message-MyMessage", (Object)new Person());
        this.completeWork(ksession, humanTaskMockHandler);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((String)"Expected process to have been completed and removed", (Object)process);
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("nodeInstance") instanceof HumanTaskNodeInstance));
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("event") instanceof Person));
        Assert.assertEquals((Object)dataTaskMockHandler.getInputParameter("signal"), (Object)"Message-MyMessage");
    }

    @Test
    public void testBoundaryEventSignalAndCompleteHumanTask() throws InterruptedException {
        this.createRuntimeManager(new String[]{PROCESS_SIGNAL_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        Assert.assertTrue((String)"session id not saved.", (ksessionId > 0L ? 1 : 0) != 0);
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler();
        DataTaskMockHandler dataTaskMockHandler = new DataTaskMockHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_TASK, (WorkItemHandler)humanTaskMockHandler);
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_DATA, (WorkItemHandler)dataTaskMockHandler);
        ProcessInstance process = ksession.startProcess(PROCESS_SIGNAL_NAME);
        long processId = process.getId();
        Assert.assertTrue((String)"process id not saved", (processId > 0L ? 1 : 0) != 0);
        int processState = process.getState();
        Assert.assertEquals((String)("Expected process state to be " + processStateName[1] + " not " + processStateName[processState]), (long)1L, (long)processState);
        ksession.signalEvent("MySignal", (Object)new Person());
        this.completeWork(ksession, humanTaskMockHandler);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((String)"Expected process to have been completed and removed", (Object)process);
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("nodeInstance") instanceof HumanTaskNodeInstance));
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("event") instanceof Person));
        Assert.assertEquals((Object)dataTaskMockHandler.getInputParameter("signal"), (Object)"MySignal");
    }

    @Test
    public void testBoundaryErrorSignalAndCompleteHumanTask() throws InterruptedException {
        this.createRuntimeManager(new String[]{PROCESS_ERROR_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        Assert.assertTrue((String)"session id not saved.", (ksessionId > 0L ? 1 : 0) != 0);
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler(true);
        DataTaskMockHandler dataTaskMockHandler = new DataTaskMockHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_TASK, (WorkItemHandler)humanTaskMockHandler);
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_DATA, (WorkItemHandler)dataTaskMockHandler);
        ProcessInstance process = ksession.startProcess(PROCESS_ERROR_NAME);
        long processId = process.getId();
        Assert.assertTrue((String)"process id not saved", (processId > 0L ? 1 : 0) != 0);
        ksession.abortProcessInstance(processId);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((String)"Expected process to have been completed and removed", (Object)process);
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("nodeInstance") instanceof HumanTaskNodeInstance));
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("event") instanceof RuntimeException));
        Assert.assertEquals((Object)dataTaskMockHandler.getInputParameter("signal"), (Object)"Error-_2-401");
    }

    @Test
    public void testBoundaryEscalationSignalAndCompleteHumanTask() throws InterruptedException {
        this.createRuntimeManager(new String[]{PROCESS_ESCALATION_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        Assert.assertTrue((String)"session id not saved.", (ksessionId > 0L ? 1 : 0) != 0);
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler(true);
        DataTaskMockHandler dataTaskMockHandler = new DataTaskMockHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_TASK, (WorkItemHandler)humanTaskMockHandler);
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_DATA, (WorkItemHandler)dataTaskMockHandler);
        ProcessInstance process = ksession.startProcess(PROCESS_ESCALATION_NAME);
        long processId = process.getId();
        Assert.assertTrue((String)"process id not saved", (processId > 0L ? 1 : 0) != 0);
        int processState = process.getState();
        Assert.assertEquals((String)("Expected process state to be " + processStateName[2] + " not " + processStateName[processState]), (long)2L, (long)processState);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((String)"Expected process to have been completed and removed", (Object)process);
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("nodeInstance") instanceof CompositeContextNodeInstance));
        Assert.assertEquals((Object)dataTaskMockHandler.getInputParameter("signal"), (Object)"Escalation-_2-201");
        Assert.assertNull((Object)dataTaskMockHandler.getInputParameter("event"));
    }

    @Test
    public void testBoundaryCompensationSignalAndCompleteHumanTask() throws InterruptedException {
        this.createRuntimeManager(new String[]{PROCESS_COMPENSATION_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        Assert.assertTrue((String)"session id not saved.", (ksessionId > 0L ? 1 : 0) != 0);
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler();
        DataTaskMockHandler dataTaskMockHandler = new DataTaskMockHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_TASK, (WorkItemHandler)humanTaskMockHandler);
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_DATA, (WorkItemHandler)dataTaskMockHandler);
        ProcessInstance process = ksession.startProcess(PROCESS_COMPENSATION_NAME);
        long processId = process.getId();
        Assert.assertTrue((String)"process id not saved", (processId > 0L ? 1 : 0) != 0);
        int processState = process.getState();
        Assert.assertEquals((String)("Expected process state to be " + processStateName[1] + " not " + processStateName[processState]), (long)1L, (long)processState);
        this.completeWork(ksession, humanTaskMockHandler);
        ksession.signalEvent("Compensation", (Object)"_2");
        this.completeWork(ksession, humanTaskMockHandler);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((String)"Expected process to have been completed and removed", (Object)process);
        Assert.assertNull((Object)dataTaskMockHandler.getInputParameter("nodeInstance"));
        Assert.assertEquals((Object)dataTaskMockHandler.getInputParameter("event"), (Object)"_2");
        Assert.assertEquals((Object)dataTaskMockHandler.getInputParameter("signal"), (Object)"Compensation");
    }

    @Test
    public void testBoundaryConditionalSignalAndCompleteHumanTask() throws InterruptedException {
        this.createRuntimeManager(new String[]{PROCESS_CONDITIONAL_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        Assert.assertTrue((String)"session id not saved.", (ksessionId > 0L ? 1 : 0) != 0);
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler();
        DataTaskMockHandler dataTaskMockHandler = new DataTaskMockHandler();
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_TASK, (WorkItemHandler)humanTaskMockHandler);
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANDLER_DATA, (WorkItemHandler)dataTaskMockHandler);
        ProcessInstance process = ksession.startProcess(PROCESS_CONDITIONAL_NAME);
        long processId = process.getId();
        Assert.assertTrue((String)"process id not saved", (processId > 0L ? 1 : 0) != 0);
        int processState = process.getState();
        Assert.assertEquals((String)("Expected process state to be " + processStateName[1] + " not " + processStateName[processState]), (long)1L, (long)processState);
        ksession.signalEvent("RuleFlowStateEvent-BoundaryConditionalEventProcess-4-_2", (Object)new Person(Long.valueOf(1L), "john"));
        this.completeWork(ksession, humanTaskMockHandler);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((String)"Expected process to have been completed and removed", (Object)process);
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("nodeInstance") instanceof HumanTaskNodeInstance));
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("event") instanceof Person));
        Assert.assertEquals((Object)dataTaskMockHandler.getInputParameter("signal"), (Object)"RuleFlowStateEvent-BoundaryConditionalEventProcess-4-_2");
        Assert.assertTrue((boolean)(dataTaskMockHandler.getInputParameter("workItem") instanceof WorkItem));
    }

    private void completeWork(KieSession ksession, HumanTaskMockHandler humanTaskMockHandler) {
        Assert.assertTrue((String)"The work item task handler does not have a work item!", (humanTaskMockHandler.workItem != null ? 1 : 0) != 0);
        long workItemId = humanTaskMockHandler.workItem.getId();
        Assert.assertTrue((String)"work item id not saved", (workItemId > 0L ? 1 : 0) != 0);
        HashMap results = new HashMap();
        try {
            ksession.getWorkItemManager().completeWorkItem(workItemId, results);
        }
        catch (Exception e) {
            logger.warn("Work item could not be completed!");
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + " thrown when completing work item: " + e.getMessage()));
        }
    }

    private void sleepAndVerifyTimerRuns() {
        try {
            int sleep = 3000;
            logger.debug("Sleeping {} seconds", (Object)(sleep / 1000));
            Thread.sleep(sleep);
            logger.debug("Awake!");
        }
        catch (InterruptedException e) {
            logger.error("System was interrupted");
            Assert.fail((String)"Junit was interrupted");
        }
    }

    private static class DataTaskMockHandler
    implements org.drools.core.process.instance.WorkItemHandler {
        private WorkItemManager workItemManager;
        private WorkItem workItem;

        private DataTaskMockHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
            this.workItemManager = manager;
            logger.debug("Work completed!");
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItemManager.abortWorkItem(workItem.getId());
            logger.debug("Work aborted.");
        }

        public Object getInputParameter(String name) {
            return this.workItem.getParameter(name);
        }
    }

    private static class HumanTaskMockHandler
    implements org.drools.core.process.instance.WorkItemHandler {
        private WorkItemManager workItemManager;
        private WorkItem workItem;
        private boolean error;

        public HumanTaskMockHandler() {
            this(false);
        }

        public HumanTaskMockHandler(boolean error) {
            this.error = error;
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
            this.workItemManager = manager;
            if (this.error) {
                throw new RuntimeException("this is an error");
            }
            logger.debug("Work completed!");
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItemManager.abortWorkItem(workItem.getId());
            logger.debug("Work aborted.");
        }
    }
}

