/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.jobexec;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.task.audit.service.TaskJPAAuditService;
import org.jbpm.test.JbpmAsyncJobTestCase;
import org.jbpm.test.listener.CountDownAsyncJobListener;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;

public class LogCleanupCommandTest
extends JbpmAsyncJobTestCase {
    public static final String HELLO_WORLD = "org/jbpm/test/functional/common/HelloWorldProcess1.bpmn";
    public static final String HELLO_WORLD_ID = "org.jbpm.test.functional.common.HelloWorldProcess1";
    public static final String LOG_CLEANUP = "org/jbpm/test/functional/jobexec/LogCleanupCommand.bpmn2";
    public static final String LOG_CLEANUP_ID = "org.jbpm.test.functional.jobexec.LogCleanupCommand";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String ANOTHER_PROCESS = "hi";
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private TaskJPAAuditService taskAuditService;
    private JPAAuditLogService auditLogService;
    private EntityManagerFactory emfErrors = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.taskAuditService = new TaskJPAAuditService(this.getEmf());
        this.taskAuditService.clear();
        this.auditLogService = new JPAAuditLogService(this.getEmf());
        this.auditLogService.clear();
        this.emfErrors = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.persistence.complete");
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.taskAuditService.clear();
            this.taskAuditService.dispose();
            this.auditLogService.clear();
            this.auditLogService.dispose();
            if (this.emfErrors != null) {
                this.emfErrors.close();
            }
        }
        finally {
            super.tearDown();
        }
    }

    @Test(timeout=10000L)
    public void skipProcessLog() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        KieSession kieSession = this.createKSession(HELLO_WORLD);
        this.startProcess(kieSession, HELLO_WORLD_ID, 1);
        Assertions.assertThat((int)this.getProcessLogSize(HELLO_WORLD_ID)).isEqualTo(1);
        Assertions.assertThat((int)this.getNodeInstanceLogSize(HELLO_WORLD_ID)).isPositive();
        this.scheduleLogCleanup(true, false, false, this.getTomorrow(), null, HELLO_WORLD_ID);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)this.getProcessLogSize(HELLO_WORLD_ID)).isEqualTo(1);
        Assertions.assertThat((int)this.getNodeInstanceLogSize(HELLO_WORLD_ID)).isPositive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test(timeout=10000L)
    public void skipTaskLog() throws Exception {
        KieSession kieSession = null;
        List<ProcessInstance> processInstanceList = null;
        try {
            CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
            ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
            kieSession = this.createKSession(LOG_CLEANUP);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("assigneeName", "krisv");
            processInstanceList = this.startProcess(kieSession, LOG_CLEANUP_ID, paramMap, 1);
            TaskService taskService = this.getRuntimeEngine().getTaskService();
            List taskIdList = taskService.getTasksByProcessInstanceId(processInstanceList.get(0).getId());
            taskService.start(((Long)taskIdList.get(0)).longValue(), "krisv");
            taskService.complete(((Long)taskIdList.get(0)).longValue(), "krisv", null);
            Assertions.assertThat((int)this.getProcessLogSize(LOG_CLEANUP_ID)).isEqualTo(1);
            Assertions.assertThat((int)this.getTaskLogSize(LOG_CLEANUP_ID)).isEqualTo(1);
            Assertions.assertThat((int)this.getNodeInstanceLogSize(LOG_CLEANUP_ID)).isPositive();
            Assertions.assertThat((int)this.getVariableLogSize(LOG_CLEANUP_ID)).isEqualTo(3);
            this.scheduleLogCleanup(false, true, false, this.getTomorrow(), null, LOG_CLEANUP_ID);
            countDownListener.waitTillCompleted();
            Assertions.assertThat((int)this.getProcessLogSize(LOG_CLEANUP_ID)).isZero();
            Assertions.assertThat((int)this.getTaskLogSize(LOG_CLEANUP_ID)).isEqualTo(1);
            Assertions.assertThat((int)this.getNodeInstanceLogSize(LOG_CLEANUP_ID)).isZero();
            Assertions.assertThat((int)this.getVariableLogSize(LOG_CLEANUP_ID)).isZero();
            if (processInstanceList == null) return;
        }
        catch (Throwable throwable) {
            if (processInstanceList == null) throw throwable;
            this.abortProcess(kieSession, processInstanceList);
            throw throwable;
        }
        this.abortProcess(kieSession, processInstanceList);
    }

    private void deleteAllLogsOlderThan(Date date, CountDownAsyncJobListener countDownListener) throws Exception {
        this.deleteAllLogsOlderThan(date, HELLO_WORLD_ID, HELLO_WORLD_ID, countDownListener);
    }

    private void deleteAllLogsOlderThan(Date date, String runProcess, String cleanProcess, CountDownAsyncJobListener countDownListener) throws Exception {
        KieSession kieSession = this.createKSession(HELLO_WORLD);
        this.startProcess(kieSession, runProcess, 1);
        Assertions.assertThat((int)this.getProcessLogSize(runProcess)).isPositive();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(runProcess)).isPositive();
        if (date == null) {
            date = new Date();
        }
        this.scheduleLogCleanup(false, false, false, date, null, cleanProcess);
        countDownListener.waitTillCompleted();
    }

    @Test(timeout=10000L)
    public void deleteAllLogsOlderThanYesterday() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        this.deleteAllLogsOlderThan(this.getYesterday(), countDownListener);
        Assertions.assertThat((int)this.getProcessLogSize(HELLO_WORLD_ID)).isPositive();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(HELLO_WORLD_ID)).isPositive();
    }

    @Test(timeout=10000L)
    public void deleteAllLogsOlderThanNow() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        this.deleteAllLogsOlderThan(null, countDownListener);
        Assertions.assertThat((int)this.getProcessLogSize(HELLO_WORLD_ID)).isZero();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(HELLO_WORLD_ID)).isZero();
    }

    @Test(timeout=10000L)
    public void deleteAllLogsOlderThanTomorrow() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        this.deleteAllLogsOlderThan(this.getTomorrow(), countDownListener);
        Assertions.assertThat((int)this.getProcessLogSize(HELLO_WORLD_ID)).isZero();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(HELLO_WORLD_ID)).isZero();
    }

    @Test(timeout=10000L)
    public void deleteAllLogsOlderThanTomorrowDifferentProcess() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        this.deleteAllLogsOlderThan(this.getTomorrow(), HELLO_WORLD_ID, ANOTHER_PROCESS, countDownListener);
        Assertions.assertThat((int)this.getProcessLogSize(HELLO_WORLD_ID)).isPositive();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(HELLO_WORLD_ID)).isPositive();
    }

    @Test(timeout=10000L)
    public void deleteAllLogsOlderThanPeriod() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        KieSession kieSession = this.createKSession(HELLO_WORLD);
        this.startProcess(kieSession, HELLO_WORLD_ID, 3);
        Thread.sleep(1010L);
        Assertions.assertThat((int)this.getProcessLogSize(HELLO_WORLD_ID)).isEqualTo(3);
        Assertions.assertThat((int)this.getNodeInstanceLogSize(HELLO_WORLD_ID)).isPositive();
        this.scheduleLogCleanup(false, false, false, null, "1s", HELLO_WORLD_ID);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)this.getProcessLogSize(HELLO_WORLD_ID)).isZero();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(HELLO_WORLD_ID)).isZero();
    }

    private int getProcessLogSize(String processId) {
        return ((ProcessInstanceLogQueryBuilder)this.auditLogService.processInstanceLogQuery().processId(new String[]{processId})).build().getResultList().size();
    }

    private int getTaskLogSize(String processId) {
        return this.taskAuditService.auditTaskQuery().processId(new String[]{processId}).build().getResultList().size();
    }

    private int getNodeInstanceLogSize(String processId) {
        return ((NodeInstanceLogQueryBuilder)this.auditLogService.nodeInstanceLogQuery().processId(new String[]{processId})).build().getResultList().size();
    }

    private int getVariableLogSize(String processId) {
        return ((VariableInstanceLogQueryBuilder)this.auditLogService.variableInstanceLogQuery().processId(new String[]{processId})).build().getResultList().size();
    }

    private void scheduleLogCleanup(boolean skipProcessLog, boolean skipTaskLog, boolean skipExecutorLog, Date olderThan, String olderThanDuration, String forProcess) {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("EmfName", (Object)"org.jbpm.persistence.complete");
        commandContext.setData("SkipProcessLog", (Object)String.valueOf(skipProcessLog));
        commandContext.setData("SkipTaskLog", (Object)String.valueOf(skipTaskLog));
        commandContext.setData("SkipExecutorLog", (Object)String.valueOf(skipExecutorLog));
        commandContext.setData("SingleRun", (Object)"true");
        commandContext.setData("DateFormat", (Object)this.dateFormat);
        if (olderThan != null) {
            commandContext.setData("OlderThan", (Object)new SimpleDateFormat(this.dateFormat).format(olderThan));
        }
        if (olderThanDuration != null) {
            commandContext.setData("OlderThanPeriod", (Object)olderThanDuration);
        }
        commandContext.setData("ForProcess", (Object)forProcess);
        this.getExecutorService().scheduleRequest("org.jbpm.executor.commands.LogCleanupCommand", (org.kie.api.executor.CommandContext)commandContext);
    }

    private Date getTomorrow() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, 1);
        return c.getTime();
    }

    private Date getYesterday() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        return c.getTime();
    }
}

