/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;

public class HumanTaskSwimlaneTest
extends JbpmTestCase {
    private static final String SWIMLANE_SAME_GROUPS = "org/jbpm/test/regression/task/HumanTaskSwimlane-sameGroups.bpmn2";
    private static final String SWIMLANE_SAME_GROUPS_ID = "org.jbpm.test.regression.task.HumanTaskSwimlane-sameGroups";
    private static final String SWIMLANE_DIFFERENT_GROUPS = "org/jbpm/test/regression/task/HumanTaskSwimlane-differentGroups.bpmn2";
    private static final String SWIMLANE_DIFFERENT_GROUPS_ID = "org.jbpm.test.regression.task.HumanTaskSwimlane-differentGroups";
    private static final String SWIMLANE_MULTIPLE_ACTORS = "org/jbpm/test/regression/task/HumanTaskSwimlane-multipleActors.bpmn2";
    private static final String SWIMLANE_MULTIPLE_ACTORS_ID = "org.jbpm.test.regression.task.HumanTaskSwimlane-multipleActors";
    private TaskService taskService;

    @Test
    public void testSameGroups() {
        this.createRuntimeManager(new String[]{SWIMLANE_SAME_GROUPS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        this.taskService = this.getRuntimeEngine().getTaskService();
        ProcessInstance pi = ksession.startProcess(SWIMLANE_SAME_GROUPS_ID);
        long task1 = this.getActiveTask(pi).getId();
        this.taskService.claim(task1, "john");
        this.taskService.start(task1, "john");
        this.taskService.complete(task1, "john", null);
        Task task2 = this.getActiveTask(pi);
        Assertions.assertThat((Comparable)task2.getTaskData().getStatus()).isEqualTo((Object)Status.Reserved);
        Assertions.assertThat((String)task2.getTaskData().getActualOwner().getId()).isEqualTo("john");
        Assertions.assertThat((String)((OrganizationalEntity)task2.getPeopleAssignments().getPotentialOwners().get(0)).getId()).isEqualTo("users");
    }

    @Test
    public void testDifferentGroups() {
        this.createRuntimeManager(new String[]{SWIMLANE_DIFFERENT_GROUPS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        this.taskService = this.getRuntimeEngine().getTaskService();
        ProcessInstance pi = ksession.startProcess(SWIMLANE_DIFFERENT_GROUPS_ID);
        long task1 = this.getActiveTask(pi).getId();
        this.taskService.claim(task1, "john");
        this.taskService.start(task1, "john");
        this.taskService.complete(task1, "john", null);
        Task task2 = this.getActiveTask(pi);
        Assertions.assertThat((Comparable)task2.getTaskData().getStatus()).isEqualTo((Object)Status.Ready);
        Assertions.assertThat((Object)task2.getTaskData().getActualOwner()).isNull();
        Assertions.assertThat((String)((OrganizationalEntity)task2.getPeopleAssignments().getPotentialOwners().get(0)).getId()).isEqualTo("sales");
    }

    private Task getActiveTask(ProcessInstance pi) {
        List taskIds = this.taskService.getTasksByProcessInstanceId(pi.getId());
        for (Long taskId : taskIds) {
            Task task = this.taskService.getTaskById(taskId.longValue());
            if (task.getTaskData().getStatus().equals((Object)Status.Completed)) continue;
            return task;
        }
        return null;
    }

    @Test
    public void testSwimlaneWithMultipleActorsAssigned() {
        this.createRuntimeManager(new String[]{SWIMLANE_MULTIPLE_ACTORS});
        String user = "john";
        RuntimeEngine runtime = this.getRuntimeEngine();
        KieSession kSession = runtime.getKieSession();
        TaskService taskservice = runtime.getTaskService();
        kSession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                if (event.getNodeInstance().getNodeName().equals("TASK")) {
                    Object swimlaneActorId = ((HumanTaskNodeInstance)event.getNodeInstance()).getWorkItem().getParameter("SwimlaneActorId");
                    Assert.assertNull((Object)swimlaneActorId);
                }
            }
        });
        HashMap map = new HashMap();
        ProcessInstance instance = kSession.startProcess(SWIMLANE_MULTIPLE_ACTORS_ID, map);
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Ready);
        statuses.add(Status.Reserved);
        statuses.add(Status.InProgress);
        List tasks = taskservice.getTasksByStatusByProcessInstanceId(instance.getId(), statuses, "en_US");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)Status.Ready, (Object)task.getStatus());
        taskservice.claim(task.getId().longValue(), user);
        taskservice.start(task.getId().longValue(), user);
        tasks = taskservice.getTasksByStatusByProcessInstanceId(instance.getId(), statuses, "en_US");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        task = (TaskSummary)tasks.get(0);
        Assert.assertEquals((Object)Status.InProgress, (Object)task.getStatus());
        taskservice.complete(task.getId().longValue(), user, map);
        this.assertProcessInstanceCompleted(instance.getId());
    }
}

