/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.List;
import java.util.Map;
import org.jbpm.process.workitem.bpmn2.BusinessRuleTaskHandler;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.domain.Person;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;

public class BusinessRuleTaskTest
extends JbpmTestCase {
    private static final String RULE_TASK = "org/jbpm/test/functional/task/businessRuleTaskProcess.bpmn2";
    private static final String RULE_TASK_ID = "org.jbpm.test.functional.task.businessRuleTask";
    private static final String RULE_TASK_COLLECTION = "org/jbpm/test/functional/task/businessRuleCollectionTaskProcess.bpmn2";
    private static final String RULE_TASK_COLLECTION_ID = "org.jbpm.test.functional.task.businessRuleTask";
    private static final String GROUP_ID = "org.jbpm";
    private static final String ARTIFACT_ID = "test-kjar";
    private static final String VERSION = "1.0";
    private KieServices ks = KieServices.Factory.get();

    public BusinessRuleTaskTest() {
        super(false);
    }

    @Test
    public void testRuleTask() throws Exception {
        this.createAndDeployJar(this.ks, this.ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION), this.ks.getResources().newClassPathResource("org/jbpm/test/functional/task/buildPersonDecision.dmn"), this.ks.getResources().newFileSystemResource("src/main/java/org/jbpm/test/domain/Person.java"));
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION, 0L, ((Object)((Object)this)).getClass().getClassLoader(), this.manager);
        this.addWorkItemHandler("BusinessRuleTask", (WorkItemHandler)handler);
        KieSession kieSession = this.createKSession(RULE_TASK);
        handler.setRuntimeManager(this.manager);
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("org.jbpm.test.functional.task.businessRuleTask");
        Assert.assertTrue((boolean)(pi.getVariable("person") instanceof Person));
    }

    @Test
    public void testRuleTaskCollection() throws Exception {
        this.createAndDeployJar(this.ks, this.ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION), this.ks.getResources().newClassPathResource("org/jbpm/test/functional/task/buildPersonCollectionDecision.dmn"), this.ks.getResources().newFileSystemResource("src/main/java/org/jbpm/test/domain/Person.java"));
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION, 0L, ((Object)((Object)this)).getClass().getClassLoader(), this.manager);
        this.addWorkItemHandler("BusinessRuleTask", (WorkItemHandler)handler);
        KieSession kieSession = this.createKSession(RULE_TASK_COLLECTION);
        handler.setRuntimeManager(this.manager);
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("org.jbpm.test.functional.task.businessRuleTask");
        Assert.assertTrue((boolean)(pi.getVariable("person") instanceof List));
        Assert.assertTrue((boolean)(((List)pi.getVariable("person")).get(0) instanceof Person));
    }

    @Override
    public KieSession createKSession(Map<String, ResourceType> res) {
        this.createRuntimeManager(res);
        return this.getRuntimeEngine().getKieSession();
    }
}

