/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.workitem.bpmn2.BusinessRuleTaskHandler;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.domain.Person;
import org.jbpm.test.domain.Structure;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;

public class BusinessRuleTaskTest
extends JbpmTestCase {
    private static final String RULE_TASK = "org/jbpm/test/functional/task/businessRuleTaskProcess.bpmn2";
    private static final String RULE_TASK_ID = "org.jbpm.test.functional.task.businessRuleTask";
    private static final String RULE_TASK_COLLECTION = "org/jbpm/test/functional/task/businessRuleCollectionTaskProcess.bpmn2";
    private static final String RULE_TASK_COLLECTION_ID = "org.jbpm.test.functional.task.businessRuleTask";
    private static final String GROUP_ID = "org.jbpm";
    private static final String ARTIFACT_ID = "test-kjar";
    private static final String VERSION = "1.0";
    private KieServices ks = KieServices.Factory.get();

    public BusinessRuleTaskTest() {
        super(false);
    }

    @Test
    public void testRuleTask() throws Exception {
        this.createAndDeployJar(this.ks, this.ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION), this.ks.getResources().newClassPathResource("org/jbpm/test/functional/task/buildPersonDecision.dmn"), this.ks.getResources().newFileSystemResource("src/main/java/org/jbpm/test/domain/Person.java"));
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION, 0L, ((Object)((Object)this)).getClass().getClassLoader(), this.manager);
        this.addWorkItemHandler("BusinessRuleTask", (WorkItemHandler)handler);
        KieSession kieSession = this.createKSession(RULE_TASK);
        handler.setRuntimeManager(this.manager);
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("org.jbpm.test.functional.task.businessRuleTask");
        Assert.assertTrue((boolean)(pi.getVariable("person") instanceof Person));
    }

    @Test
    public void testBuildDMNStructureProcess() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("org/jbpm/test/functional/task/buildDMNStructureProcess.bpmn", ResourceType.BPMN2);
        resources.put("org/jbpm/test/functional/task/buildDMNStructure.dmn", ResourceType.DMN);
        KieSession kieSession = this.createKSession(resources);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", "john");
        params.put("age", 35);
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("dmn-bpmn.buildDMNStructureProcess", params);
        Assert.assertTrue((boolean)(pi.getVariable("person") instanceof Person));
        Person variable = (Person)pi.getVariable("person");
        Assert.assertEquals((Object)"john", (Object)variable.getName());
        Assert.assertEquals((long)35L, (long)variable.getAge());
        Assert.assertNull((Object)variable.getAddress());
        Assert.assertEquals((long)2L, (long)pi.getState());
    }

    @Test
    public void testBuildDMNNestedStructureProcess() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("org/jbpm/test/functional/task/buildDMNNestedStructureProcess.bpmn", ResourceType.BPMN2);
        resources.put("org/jbpm/test/functional/task/buildDMNNestedStructure.dmn", ResourceType.DMN);
        KieSession kieSession = this.createKSession(resources);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", "john");
        params.put("age", 35);
        params.put("street", "time square");
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("dmn-bpmn.buildDMNNestedStructureProcess", params);
        Assert.assertTrue((boolean)(pi.getVariable("person") instanceof Person));
        Person variable = (Person)pi.getVariable("person");
        Assert.assertEquals((Object)"john", (Object)variable.getName());
        Assert.assertEquals((long)35L, (long)variable.getAge());
        Assert.assertEquals((Object)"time square", (Object)variable.getAddress().getStreet());
        Assert.assertEquals((long)2L, (long)pi.getState());
    }

    @Test
    public void testBuildDMNStructureFieldNameMismatchProcess() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("org/jbpm/test/functional/task/buildDMNStructureFieldNameMismatchProcess.bpmn", ResourceType.BPMN2);
        resources.put("org/jbpm/test/functional/task/buildDMNStructureFieldNameMismatch.dmn", ResourceType.DMN);
        KieSession kieSession = this.createKSession(resources);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", "john");
        params.put("age", 35);
        params.put("street", "time square");
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("dmn-bpmn.buildDMNStructureFieldNameMismatchProcess", params);
        Assert.assertTrue((boolean)(pi.getVariable("person") instanceof Person));
        Person variable = (Person)pi.getVariable("person");
        Assert.assertEquals((Object)"", (Object)variable.getName());
        Assert.assertEquals((long)35L, (long)variable.getAge());
        Assert.assertEquals((long)2L, (long)pi.getState());
    }

    @Test
    public void testBuildDMNWithMoreTypesStructureProcess() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("org/jbpm/test/functional/task/buildDMNWithMoreTypesStructureProcess.bpmn", ResourceType.BPMN2);
        resources.put("org/jbpm/test/functional/task/buildDMNWithMoreTypesStructure.dmn", ResourceType.DMN);
        KieSession kieSession = this.createKSession(resources);
        HashMap params = new HashMap();
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("dmn-bpmn.buildDMNWithMoreTypesStructureProcess", params);
        Structure variable = (Structure)pi.getVariable("structure");
        Assert.assertEquals((Object)123456, (Object)variable.getId());
        Assert.assertEquals((Object)"value a", variable.getCache().get("keyA"));
        Assert.assertEquals((Object)"value b", variable.getCache().get("keyB"));
        Assert.assertEquals((Object)LocalDate.of(2021, 6, 11), (Object)variable.getCurrentDate());
        Assert.assertEquals((Object)LocalDateTime.of(LocalDate.of(2021, 6, 11), LocalTime.of(7, 49, 0)), (Object)variable.getCurrentDateTime());
        Assert.assertEquals((Object)LocalTime.of(7, 49, 0), (Object)variable.getCurrentTime());
        Assert.assertEquals((long)169950L, (long)variable.getDaysTimeDuration().getSeconds());
        Assert.assertEquals((long)3L, (long)variable.getYearsMonthsDuration().getYears());
        Assert.assertEquals((long)5L, (long)variable.getYearsMonthsDuration().getMonths());
        Assert.assertEquals((long)2L, (long)pi.getState());
    }

    @Test
    public void testBuildDMNDateProcess() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("org/jbpm/test/functional/task/buildDMNDateProcess.bpmn", ResourceType.BPMN2);
        resources.put("org/jbpm/test/functional/task/buildDMNDate.dmn", ResourceType.DMN);
        KieSession kieSession = this.createKSession(resources);
        HashMap params = new HashMap();
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("dmn-bpmn.buildDMNDateProcess", params);
        LocalDate variable = (LocalDate)pi.getVariable("date");
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((long)2L, (long)pi.getState());
    }

    @Test
    public void testBuildDMNPeriodProcess() throws Exception {
        HashMap<String, ResourceType> resources = new HashMap<String, ResourceType>();
        resources.put("org/jbpm/test/functional/task/buildDMNPeriodProcess.bpmn", ResourceType.BPMN2);
        resources.put("org/jbpm/test/functional/task/buildDMNPeriod.dmn", ResourceType.DMN);
        KieSession kieSession = this.createKSession(resources);
        HashMap params = new HashMap();
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("dmn-bpmn.buildDMNPeriodProcess", params);
        Period variable = (Period)pi.getVariable("period");
        Assert.assertEquals((long)1L, (long)variable.getYears());
        Assert.assertEquals((long)5L, (long)variable.getMonths());
        Assert.assertEquals((long)2L, (long)pi.getState());
    }

    @Test
    public void testRuleTaskCollection() throws Exception {
        this.createAndDeployJar(this.ks, this.ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION), this.ks.getResources().newClassPathResource("org/jbpm/test/functional/task/buildPersonCollectionDecision.dmn"), this.ks.getResources().newFileSystemResource("src/main/java/org/jbpm/test/domain/Person.java"));
        BusinessRuleTaskHandler handler = new BusinessRuleTaskHandler(GROUP_ID, ARTIFACT_ID, VERSION, 0L, ((Object)((Object)this)).getClass().getClassLoader(), this.manager);
        this.addWorkItemHandler("BusinessRuleTask", (WorkItemHandler)handler);
        KieSession kieSession = this.createKSession(RULE_TASK_COLLECTION);
        handler.setRuntimeManager(this.manager);
        WorkflowProcessInstanceImpl pi = (WorkflowProcessInstanceImpl)kieSession.startProcess("org.jbpm.test.functional.task.businessRuleTask");
        Assert.assertTrue((boolean)(pi.getVariable("person") instanceof List));
        Assert.assertTrue((boolean)(((List)pi.getVariable("person")).get(0) instanceof Person));
    }

    @Override
    public KieSession createKSession(Map<String, ResourceType> res) {
        this.createRuntimeManager(res);
        return this.getRuntimeEngine().getKieSession();
    }
}

