/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.test.AbstractBaseTest;
import org.jbpm.test.util.PoolingDataSource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimerBaseTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(TimerBaseTest.class);
    private static PoolingDataSource pds;
    protected static final String DATASOURCE_PROPERTIES = "/datasource.properties";
    protected static final String MAX_POOL_SIZE = "maxPoolSize";
    protected static final String ALLOW_LOCAL_TXS = "allowLocalTransactions";
    protected static final String DATASOURCE_CLASS_NAME = "className";
    protected static final String DRIVER_CLASS_NAME = "driverClassName";
    protected static final String USER = "user";
    protected static final String PASSWORD = "password";
    protected static final String JDBC_URL = "url";

    public static PoolingDataSource setupPoolingDataSource() {
        Properties dsProps = TimerBaseTest.getDatasourceProperties();
        PoolingDataSource pds = PersistenceUtil.setupPoolingDataSource((Properties)dsProps, (String)"jdbc/jbpm-ds", (boolean)false);
        try {
            pds.init();
        }
        catch (Exception e) {
            logger.warn("DBPOOL_MGR:Looks like there is an issue with creating db pool because of " + e.getMessage() + " cleaing up...");
            try {
                pds.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.info("DBPOOL_MGR: attempting to create db pool again...");
            pds = PersistenceUtil.setupPoolingDataSource((Properties)dsProps, (String)"jdbc/jbpm-ds", (boolean)false);
            pds.init();
            logger.info("DBPOOL_MGR:Pool created after cleanup of leftover resources");
        }
        return pds;
    }

    private static Properties getDatasourceProperties() {
        String password;
        boolean propertiesNotFound = false;
        System.setProperty("h2.lobInDatabase", "true");
        InputStream propsInputStream = TimerBaseTest.class.getResourceAsStream(DATASOURCE_PROPERTIES);
        Properties props = new Properties();
        if (propsInputStream != null) {
            try {
                props.load(propsInputStream);
            }
            catch (IOException ioe) {
                propertiesNotFound = true;
                logger.warn("Unable to find properties, using default H2 properties: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        } else {
            propertiesNotFound = true;
        }
        if ("${maven.jdbc.password}".equals(password = props.getProperty(PASSWORD)) || propertiesNotFound) {
            logger.warn("Unable to load datasource properties [/datasource.properties]");
        }
        TimerBaseTest.setDefaultProperties(props);
        return props;
    }

    private static void setDefaultProperties(Properties props) {
        String[] keyArr = new String[]{"serverName", "portNumber", "databaseName", JDBC_URL, USER, PASSWORD, DRIVER_CLASS_NAME, DATASOURCE_CLASS_NAME, MAX_POOL_SIZE, ALLOW_LOCAL_TXS};
        String[] defaultPropArr = new String[]{"", "", "", "jdbc:h2:mem:jbpm-db;MVCC=true", "sa", "", "org.h2.Driver", "org.h2.jdbcx.JdbcDataSource", "5", "true"};
        Assert.assertTrue((String)"Unequal number of keys for default properties", (keyArr.length == defaultPropArr.length ? 1 : 0) != 0);
        for (int i = 0; i < keyArr.length; ++i) {
            if (props.containsKey(keyArr[i])) continue;
            props.put(keyArr[i], defaultPropArr[i]);
        }
    }

    @BeforeClass
    public static void setUpOnce() {
        if (pds == null) {
            pds = TimerBaseTest.setupPoolingDataSource();
        }
    }

    @AfterClass
    public static void tearDownOnce() {
        if (pds != null) {
            pds.close();
            pds = null;
        }
    }

    protected void testCreateQuartzSchema() {
        Scanner scanner = new Scanner(((Object)((Object)this)).getClass().getResourceAsStream("/quartz_tables_h2.sql")).useDelimiter(";");
        try {
            Connection connection = ((DataSource)InitialContext.doLookup("jdbc/jbpm-ds")).getConnection();
            Statement stmt = connection.createStatement();
            while (scanner.hasNext()) {
                String sql = scanner.next();
                stmt.executeUpdate(sql);
            }
            stmt.close();
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class TestRegisterableItemsFactory
    extends DefaultRegisterableItemsFactory {
        private ProcessEventListener[] plistener;
        private AgendaEventListener[] alistener;
        private TaskLifeCycleEventListener[] tlistener;

        public TestRegisterableItemsFactory(ProcessEventListener ... listener) {
            this.plistener = listener;
        }

        public TestRegisterableItemsFactory(AgendaEventListener ... listener) {
            this.alistener = listener;
        }

        public TestRegisterableItemsFactory(TaskLifeCycleEventListener ... tlistener) {
            this.tlistener = tlistener;
        }

        public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
            List listeners = super.getProcessEventListeners(runtime);
            if (this.plistener != null) {
                listeners.addAll(Arrays.asList(this.plistener));
            }
            return listeners;
        }

        public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
            List listeners = super.getAgendaEventListeners(runtime);
            if (this.alistener != null) {
                listeners.addAll(Arrays.asList(this.alistener));
            }
            return listeners;
        }

        public List<TaskLifeCycleEventListener> getTaskListeners() {
            List listeners = super.getTaskListeners();
            if (this.tlistener != null) {
                listeners.addAll(Arrays.asList(this.tlistener));
            }
            return listeners;
        }
    }
}

